/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.artefacts;

import com.gsl.schematron.validator.artefacts.AbstractArtefact;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class FileArtefact
extends AbstractArtefact {
    private final String filePath;
    private final String shortName;
    private final File file;

    public FileArtefact(String filePath, String shortName) throws IOException {
        assert (filePath != null);
        this.filePath = filePath;
        this.shortName = shortName;
        this.file = new File(filePath);
        this.setupNamespace(filePath);
    }

    @Override
    public String getFullName() {
        return this.filePath;
    }

    @Override
    public InputStream openInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    @Override
    public String getName() {
        return this.shortName;
    }

    @Override
    public Date getLastModifiedDate() {
        return new Date(this.file.lastModified());
    }

    public String toString() {
        return "FileArtefact [fullName = '" + this.getFullName() + "', name = '" + this.getName() + "', namespace = " + this.getNamespace().toString() + "]";
    }
}

