/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.artefacts;

import com.gsl.schematron.validator.artefacts.AbstractArtefactRepository;
import com.gsl.schematron.validator.artefacts.Artefact;
import com.gsl.schematron.validator.artefacts.FileArchiveArtefactFilter;
import com.gsl.schematron.validator.artefacts.FileArchiveArtefactRepository;
import com.gsl.schematron.validator.artefacts.FileArtefact;
import com.gsl.schematron.validator.artefacts.FileArtefactFilter;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.zip.ZipFile;

public class FileArtefactRepository
extends AbstractArtefactRepository {
    public FileArtefactRepository(File dirToSearch) throws IOException {
        this(Collections.singleton(dirToSearch));
    }

    public FileArtefactRepository(Set<File> dirsToSearch) throws IOException {
        for (File dir : dirsToSearch) {
            this.populateMatchingArtefactFiles(dir);
            this.populateMatchingArtefactsFromArchives(dir);
        }
    }

    private void populateMatchingArtefactFiles(File dir) throws IOException {
        if (dir.exists() && dir.isDirectory() && dir.canRead()) {
            File[] children;
            File[] matchingFiles;
            for (File matchingFile : matchingFiles = dir.listFiles(FileArtefactFilter.instance())) {
                FileArtefact artefact = new FileArtefact(matchingFile.getPath(), matchingFile.getName());
                this.artefacts.add(artefact);
            }
            for (File element : children = dir.listFiles()) {
                this.populateMatchingArtefactFiles(element);
            }
        }
    }

    private void populateMatchingArtefactsFromArchives(File dir) throws IOException {
        if (dir.exists() && dir.isDirectory() && dir.canRead()) {
            File[] children;
            File[] matchingFiles;
            for (File matchingFile : matchingFiles = dir.listFiles(FileArchiveArtefactFilter.instance())) {
                ZipFile archive = new ZipFile(matchingFile);
                FileArchiveArtefactRepository archiveRepository = new FileArchiveArtefactRepository(archive);
                Set<Artefact> archiveEntryArtifacts = archiveRepository.getArtefacts();
                this.artefacts.addAll(archiveEntryArtifacts);
            }
            for (File element : children = dir.listFiles()) {
                this.populateMatchingArtefactsFromArchives(element);
            }
        }
    }
}

