/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.artefacts;

import com.gsl.schematron.validator.artefacts.AbstractArtefact;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileEntryArtefact
extends AbstractArtefact {
    private final String zipArchiveFilepath;
    private final String entryFilepath;
    private final String entryFilename;
    private final ZipFile archive;
    private final ZipEntry entry;

    public ZipFileEntryArtefact(String zipArchiveFilepath, String entryFilepath) throws IOException {
        this.archive = new ZipFile(zipArchiveFilepath);
        this.entry = this.archive.getEntry(entryFilepath);
        if (this.entry == null) {
            throw new FileNotFoundException("Could not find entry in " + zipArchiveFilepath + " called " + entryFilepath);
        }
        this.zipArchiveFilepath = zipArchiveFilepath;
        this.entryFilepath = entryFilepath;
        int lastFileSeparatorPos = entryFilepath.lastIndexOf(File.separator);
        this.entryFilename = entryFilepath.substring(lastFileSeparatorPos + 1);
        this.setupNamespace(entryFilepath);
    }

    @Override
    public String getFullName() {
        return this.zipArchiveFilepath + "!" + this.entryFilepath;
    }

    @Override
    public String getName() {
        return this.entryFilename;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.archive.getInputStream(this.entry);
    }

    @Override
    public Date getLastModifiedDate() {
        Date lastModified = null;
        long lastModifiedMillis = this.entry.getTime();
        if (lastModifiedMillis != -1L) {
            lastModified = new Date(lastModifiedMillis);
        }
        return lastModified;
    }

    public String toString() {
        return "ZipFileEntryArtefact [fullName = '" + this.getFullName() + "', name = '" + this.getName() + "', namespace = " + this.getNamespace().toString() + "]";
    }
}

