/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.cache.rules;

import com.gsl.logging.LoggerFactory;
import com.gsl.schematron.validator.RulesState;
import com.gsl.schematron.validator.cache.CachedValue;
import com.gsl.schematron.validator.cache.rules.RulesStateCacheEntry;
import com.gsl.schematron.validator.cache.rules.RulesStateCacheException;
import com.gsl.schematron.validator.cache.rules.RulesStateCacheKey;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class RulesStateCache {
    private static final Logger logger = LoggerFactory.getLogger(RulesStateCache.class.getName());
    private final Map<RulesStateCacheKey, CachedValue<RulesState>> rulesStateCache = new HashMap<RulesStateCacheKey, CachedValue<RulesState>>();

    public synchronized boolean populateEntryWithLatestRulesState(RulesStateCacheEntry<?> latestCacheEntry) throws RulesStateCacheException {
        boolean rulesStateRequiresRefresh = false;
        RulesStateCacheKey keySoughtInCache = (RulesStateCacheKey)latestCacheEntry.getCacheKey();
        CachedValue<RulesState> cachedValueForKeySought = null;
        cachedValueForKeySought = this.rulesStateCache.get(keySoughtInCache);
        keySoughtInCache.refreshRepository();
        boolean bl = rulesStateRequiresRefresh = cachedValueForKeySought == null ? true : cachedValueForKeySought.isRefreshRequired(keySoughtInCache);
        if (rulesStateRequiresRefresh) {
            if (cachedValueForKeySought == null) {
                cachedValueForKeySought = latestCacheEntry.createCachedValue();
                this.rulesStateCache.put(keySoughtInCache, cachedValueForKeySought);
            }
            try {
                logger.fine("Refreshing rules state:  " + latestCacheEntry.toString());
                latestCacheEntry.refreshRulesState();
                cachedValueForKeySought = latestCacheEntry.createCachedValue();
            }
            catch (Exception ex) {
                throw new RulesStateCacheException(ex);
            }
            if (this.rulesStateCache.containsKey(keySoughtInCache)) {
                this.rulesStateCache.remove(keySoughtInCache);
            }
            this.rulesStateCache.put(keySoughtInCache, cachedValueForKeySought);
        } else {
            logger.fine("Skipping rules state, as it has not changed since last read:  " + latestCacheEntry.toString());
            latestCacheEntry.setRulesState(cachedValueForKeySought.getCacheValue());
        }
        return rulesStateRequiresRefresh;
    }
}

