/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.cache.rules;

import com.gsl.io.core.stream.StreamUtils;
import com.gsl.io.core.stream.Streamable;
import com.gsl.logging.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import xmldoc.util.EntityResolutionMap;
import xmldoc.util.EntityResolver;

public class SchemaFileEntityResolver
implements EntityResolver {
    private final Logger logger = LoggerFactory.getLogger("SchemaFileEntityResolver");
    private final Map<String, Streamable> schemaMap = new HashMap<String, Streamable>();

    @Override
    public String getExternalSchemaLocations() {
        return "";
    }

    @Override
    public EntityResolutionMap getMap() {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String fileName;
        Streamable streamable;
        InputSource result = null;
        if (systemId != null && systemId.startsWith("file://") && systemId.endsWith(".xsd") && (streamable = this.schemaMap.get(fileName = systemId.substring(systemId.lastIndexOf(47) + 1))) != null) {
            try {
                byte[] bytes = StreamUtils.readAllBytesFromStream(streamable.openInputStream());
                if (bytes != null) {
                    result = new InputSource(new ByteArrayInputStream(bytes));
                }
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Could not load schema file " + streamable.toString(), e);
                throw new SAXException("Could not load schema file " + streamable.toString(), e);
            }
        }
        return result;
    }

    public void add(String name, Streamable streamable) {
        this.schemaMap.put(name, streamable);
    }
}

