/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.cache.rules;

import com.gsl.schematron.generator.ByteCodeGenerationException;
import com.gsl.schematron.generator.ClassGeneratorException;
import com.gsl.schematron.validator.RulesState;
import com.gsl.schematron.validator.cache.CachedValue;
import com.gsl.schematron.validator.cache.rules.RuleUnitRepositoryFactory;
import com.gsl.schematron.validator.cache.rules.RulesStateCacheEntry;
import com.gsl.schematron.validator.cache.rules.SchematronRulesStateCacheKey;
import com.gsl.schematron.validator.cache.rules.SchematronRulesStateCachedValue;
import com.gsl.schematron.validator.cache.rules.SchematronRulesStatePipeline;
import java.io.IOException;
import org.xml.sax.SAXException;

public class SchematronRulesStateCacheEntry
implements RulesStateCacheEntry<SchematronRulesStateCacheKey> {
    private final SchematronRulesStateCacheKey cacheKey;
    private final SchematronRulesStatePipeline generationPipeline;
    private RulesState cacheValue;

    public SchematronRulesStateCacheEntry(SchematronRulesStateCacheKey cacheKey, SchematronRulesStatePipeline generationPipeline) {
        this.cacheKey = cacheKey;
        this.generationPipeline = generationPipeline;
    }

    @Override
    public void setRuleUnitRepositoryFactory(RuleUnitRepositoryFactory repositoryFactory) {
        this.generationPipeline.setRepositoryFactory(repositoryFactory);
    }

    @Override
    public void refreshRulesState() throws ByteCodeGenerationException, ClassGeneratorException, SAXException, IOException {
        RulesState rulesState = this.generationPipeline.makeNewRulesState(this.cacheKey);
        this.setRulesState(rulesState);
    }

    @Override
    public SchematronRulesStateCacheKey getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public RulesState getCacheValue() {
        return this.cacheValue;
    }

    @Override
    public CachedValue<RulesState> createCachedValue() {
        return new SchematronRulesStateCachedValue(this.cacheKey, this.cacheValue);
    }

    @Override
    public void setRulesState(RulesState rulesStateCacheValue) {
        this.cacheValue = rulesStateCacheValue;
    }

    public String toString() {
        return "Schematron rules state";
    }
}

