/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.cache.rules;

import com.gsl.schematron.validator.artefacts.ArtefactVersionManifestBuilder;
import com.gsl.schematron.validator.cache.rules.RuleUnitRepositoryFactory;
import com.gsl.schematron.validator.cache.rules.RuleUnitRepositoryImplFactory;
import com.gsl.schematron.validator.cache.rules.RulesStateCacheException;
import com.gsl.schematron.validator.cache.rules.RulesStateCacheKey;
import com.gsl.schematron.validator.ruleUnit.RuleUnitRepository;
import com.gsl.util.HashCode;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class SchematronRulesStateCacheKey
implements RulesStateCacheKey {
    private final Set<File> dirsToSearch = new HashSet<File>();
    private final int hashCode;
    private RuleUnitRepository ruleUnitRepository;
    private RuleUnitRepositoryFactory repositoryFactory = new RuleUnitRepositoryImplFactory();

    public SchematronRulesStateCacheKey() {
        this.hashCode = this.calculateHashCode();
    }

    public SchematronRulesStateCacheKey(String schematronFileDirpath, String schemaFileDirpath) {
        this.dirsToSearch.add(new File(schematronFileDirpath));
        this.dirsToSearch.add(new File(schemaFileDirpath));
        this.hashCode = this.calculateHashCode();
    }

    private int calculateHashCode() {
        int result = 23;
        result = HashCode.hash(result, this.dirsToSearch);
        return result;
    }

    @Override
    public RuleUnitRepository getRuleUnitRepository() {
        return this.ruleUnitRepository;
    }

    @Override
    public void refreshRepository() throws RulesStateCacheException {
        try {
            this.ruleUnitRepository = this.repositoryFactory.makeRepository(this.dirsToSearch);
        }
        catch (IOException ioEx) {
            throw new RulesStateCacheException(ioEx);
        }
    }

    @Override
    public void setRuleUnitRepositoryFactory(RuleUnitRepositoryFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public Set<File> getDirsToSearch() {
        return this.dirsToSearch;
    }

    public ArtefactVersionManifestBuilder createVersionManifestBuilder() {
        ArtefactVersionManifestBuilder manifestBuilder = new ArtefactVersionManifestBuilder();
        manifestBuilder.setDirsSearched(this.dirsToSearch);
        return manifestBuilder;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SchematronRulesStateCacheKey other = (SchematronRulesStateCacheKey)o;
        return this.dirsToSearch.equals(other.dirsToSearch);
    }
}

