/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.cache.rules;

import com.gsl.schematron.validator.RulesState;
import com.gsl.schematron.validator.cache.CachedValue;
import com.gsl.schematron.validator.cache.rules.RulesStateCacheKey;
import com.gsl.schematron.validator.cache.rules.SchematronRulesStateCacheKey;
import java.util.Date;

class SchematronRulesStateCachedValue
implements CachedValue<RulesState> {
    private final SchematronRulesStateCacheKey cacheKey;
    private final RulesState rulesState;
    private final Date dateWhenValueWasFresh;

    public SchematronRulesStateCachedValue(SchematronRulesStateCacheKey cacheKey, RulesState rulesState) {
        this.cacheKey = cacheKey;
        this.rulesState = rulesState;
        this.dateWhenValueWasFresh = new Date();
    }

    @Override
    public RulesState getCacheValue() {
        return this.rulesState;
    }

    @Override
    public Date getDateWhenValueWasFresh() {
        return this.dateWhenValueWasFresh;
    }

    @Override
    public boolean isStale(RulesStateCacheKey latestCacheKey) {
        return this.cacheKey.getRuleUnitRepository().getChecksum() != latestCacheKey.getRuleUnitRepository().getChecksum();
    }

    @Override
    public boolean isRefreshRequired(RulesStateCacheKey latestCacheKey) {
        return this.isStale(latestCacheKey);
    }
}

