/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.cache.rules;

import com.gsl.docValidator.CompositeEntityResolver;
import com.gsl.io.core.stream.Streamable;
import com.gsl.schematron.RuleGeneratorParams;
import com.gsl.schematron.generator.ByteCodeGenerationException;
import com.gsl.schematron.generator.ByteCodeGenerator;
import com.gsl.schematron.generator.ByteCodeResult;
import com.gsl.schematron.generator.ClassGenerator;
import com.gsl.schematron.generator.ClassGeneratorException;
import com.gsl.schematron.generator.ClassResult;
import com.gsl.schematron.transformer.CompilableResult;
import com.gsl.schematron.transformer.RelativeLocators;
import com.gsl.schematron.transformer.RelativeLocatorsParser;
import com.gsl.schematron.transformer.SchematronResource;
import com.gsl.schematron.transformer.SchematronTransformer;
import com.gsl.schematron.transformer.SchematronTransformerParams;
import com.gsl.schematron.validator.RulesState;
import com.gsl.schematron.validator.artefacts.Artefact;
import com.gsl.schematron.validator.artefacts.ArtefactProcessor;
import com.gsl.schematron.validator.artefacts.ArtefactVersionManifestBuilder;
import com.gsl.schematron.validator.cache.rules.RuleUnitRepositoryFactory;
import com.gsl.schematron.validator.cache.rules.RuleUnitRepositoryImplFactory;
import com.gsl.schematron.validator.cache.rules.SchemaFileEntityResolver;
import com.gsl.schematron.validator.cache.rules.SchematronRulesStateCacheKey;
import com.gsl.schematron.validator.cache.rules.SchematronTransformerFactory;
import com.gsl.schematron.validator.ruleUnit.RuleUnitProcessor;
import com.gsl.schematron.validator.ruleUnit.RuleUnitProcessorImpl;
import com.gsl.schematron.validator.ruleUnit.RuleUnitRepository;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.SAXException;
import validationResponse.output.VersionManifest;
import xmldoc.util.CachingFileSystemEntityResolver;
import xmldoc.util.ClasspathEntityResolver;
import xmldoc.util.EntityResolutionMap;
import xmldoc.util.EntityResolutionMapBuilder;
import xmldoc.util.EntityResolver;

public class SchematronRulesStatePipeline {
    public static final String X_PROP_GENERATE_CLASSES = "x_generate_classes";
    private final SchematronTransformerFactory transformerFactory;
    private final SchematronTransformerParams transformerParams;
    private final ByteCodeGenerator byteCodeGenerator;
    private final ClassGenerator classGenerator;
    private final RuleGeneratorParams ruleGeneratorParams;
    private RuleUnitRepositoryFactory repositoryFactory = new RuleUnitRepositoryImplFactory();
    private RuleUnitRepository ruleUnitRepository;
    private EntityResolutionMapBuilder mapBuilder;
    private Set<SchematronResource> schematronResources;
    private ArtefactVersionManifestBuilder manifestBuilder;
    private Set<Streamable> relativeLocatorStreams;
    private RuleUnitProcessor ruleUnitProcessor;

    public SchematronRulesStatePipeline(SchematronTransformerFactory transformerFactory, SchematronTransformerParams transformerParams, ByteCodeGenerator byteCodeGenerator, ClassGenerator classGenerator, RuleGeneratorParams ruleGeneratorParams) {
        this.transformerFactory = transformerFactory;
        this.transformerParams = transformerParams;
        this.byteCodeGenerator = byteCodeGenerator;
        this.classGenerator = classGenerator;
        this.ruleGeneratorParams = ruleGeneratorParams;
    }

    public void setRepositoryFactory(RuleUnitRepositoryFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public RulesState makeNewRulesState(SchematronRulesStateCacheKey cacheKey) throws IOException, SAXException, ByteCodeGenerationException, ClassGeneratorException {
        this.buildRuleUnitRepositoryAndProcessor(cacheKey);
        this.processRuleUnits();
        RelativeLocators relativeLocators = this.parseRelativeLocatorArtefacts();
        EntityResolver entityResolver = this.makeEntityResolver();
        ClassResult classResult = null;
        boolean generateClasses = this.ruleGeneratorParams.getExtendedParams().getBoolean(X_PROP_GENERATE_CLASSES, true);
        if (generateClasses) {
            SchematronTransformer schematronTransformer = this.makeSchematronTransformer(entityResolver, relativeLocators);
            classResult = this.makeClassResult(schematronTransformer);
        }
        VersionManifest versionManifest = this.makeVersionManifest();
        RulesState rulesState = this.makeRulesState(classResult, entityResolver, versionManifest);
        return rulesState;
    }

    private void buildRuleUnitRepositoryAndProcessor(SchematronRulesStateCacheKey cacheKey) throws IOException {
        Set<File> dirsToSearch = cacheKey.getDirsToSearch();
        this.ruleUnitRepository = this.repositoryFactory.makeRepository(dirsToSearch);
        this.mapBuilder = new EntityResolutionMapBuilder();
        this.schematronResources = new HashSet<SchematronResource>();
        this.manifestBuilder = cacheKey.createVersionManifestBuilder();
        this.relativeLocatorStreams = new HashSet<Streamable>();
        this.ruleUnitProcessor = new RuleUnitProcessorImpl(this.mapBuilder, this.schematronResources, this.manifestBuilder, this.relativeLocatorStreams);
    }

    private void processRuleUnits() throws IOException {
        this.ruleUnitRepository.processRuleUnits(this.ruleUnitProcessor);
    }

    private RelativeLocators parseRelativeLocatorArtefacts() {
        RelativeLocators relativeLocators = RelativeLocatorsParser.parseRelativeLocators(this.relativeLocatorStreams);
        return relativeLocators;
    }

    private EntityResolver makeEntityResolver() throws SAXException {
        CompositeEntityResolver compositeResolver = new CompositeEntityResolver();
        EntityResolutionMap map = this.mapBuilder.makeEntityResolutionMap();
        CachingFileSystemEntityResolver cachingResolver = new CachingFileSystemEntityResolver(map);
        compositeResolver.addResolver(cachingResolver);
        final SchemaFileEntityResolver schemaResolver = new SchemaFileEntityResolver();
        ArtefactProcessor artefactProcessor = new ArtefactProcessor(){

            @Override
            public void processArtefact(Artefact artefact) {
                if (artefact.getName().endsWith(".xsd")) {
                    schemaResolver.add(artefact.getName(), artefact);
                }
            }
        };
        this.ruleUnitRepository.processArtefacts(artefactProcessor);
        compositeResolver.addResolver(schemaResolver);
        String NAMESPACE_XML = "http://www.w3.org/XML/1998/namespace";
        String NAMESPACE_DSIG = "http://www.w3.org/2000/09/xmldsig#";
        String[][] ENTITY_RESOLUTION_TABLE = new String[][]{{"http://www.w3.org/XML/1998/namespace", "/xml.xsd"}, {"http://www.w3.org/2000/09/xmldsig#", "/xml-dsig.xsd"}, {"http://www.w3.org/2001/XMLSchema.dtd", "/XMLSchema.dtd"}};
        ClasspathEntityResolver classPathResolver = new ClasspathEntityResolver(ENTITY_RESOLUTION_TABLE);
        compositeResolver.addResolver(classPathResolver);
        return compositeResolver;
    }

    private SchematronTransformer makeSchematronTransformer(EntityResolver entityResolver, RelativeLocators relativeLocators) {
        SchematronTransformer schematronTransformer = this.transformerFactory.makeTransformer(entityResolver);
        schematronTransformer.setRelativeLocators(relativeLocators);
        return schematronTransformer;
    }

    private ClassResult makeClassResult(SchematronTransformer schematronTransformer) throws ByteCodeGenerationException, ClassGeneratorException {
        SchematronResource[] schematronResourceArray = new SchematronResource[this.schematronResources.size()];
        int index = 0;
        for (SchematronResource resource : this.schematronResources) {
            schematronResourceArray[index++] = resource;
        }
        CompilableResult compilableResult = schematronTransformer.transform(schematronResourceArray, this.transformerParams);
        ByteCodeResult byteCodeResult = this.byteCodeGenerator.generate(compilableResult);
        ClassResult classResult = this.classGenerator.generate(byteCodeResult);
        this.byteCodeGenerator.postGenerationTearDown();
        return classResult;
    }

    private VersionManifest makeVersionManifest() {
        VersionManifest versionManifest = this.manifestBuilder.makeVersionManifest();
        return versionManifest;
    }

    private RulesState makeRulesState(ClassResult classResult, EntityResolver entityResolver, VersionManifest versionManifest) {
        RulesState rulesState = new RulesState(classResult, entityResolver, versionManifest);
        return rulesState;
    }
}

