/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.cache.rules;

import com.gsl.logging.LoggerFactory;
import com.gsl.schematron.RuleGeneratorParams;
import com.gsl.schematron.generator.ByteCodeGenerator;
import com.gsl.schematron.generator.ClassGenerator;
import com.gsl.schematron.generator.ClassGeneratorImpl;
import com.gsl.schematron.generator.javac.JDTByteCodeGenerator;
import com.gsl.schematron.transformer.SchematronTransformerParams;
import com.gsl.schematron.validator.RulesState;
import com.gsl.schematron.validator.cache.RefreshAwareReader;
import com.gsl.schematron.validator.cache.rules.RulesStateCache;
import com.gsl.schematron.validator.cache.rules.RulesStateCacheEntry;
import com.gsl.schematron.validator.cache.rules.RulesStateCacheException;
import com.gsl.schematron.validator.cache.rules.SchematronRulesStateCacheEntry;
import com.gsl.schematron.validator.cache.rules.SchematronRulesStateCacheKey;
import com.gsl.schematron.validator.cache.rules.SchematronRulesStatePipeline;
import com.gsl.schematron.validator.cache.rules.SchematronTransformerFactory;
import com.gsl.schematron.validator.cache.rules.SchematronTransformerFactoryImpl;
import java.util.logging.Logger;

public class SchematronRulesStateSource {
    private static final Logger logger = LoggerFactory.getLogger(SchematronRulesStateSource.class.getName());
    private final String schematronFileDirpath;
    private final String schemaFileDirpath;
    private final SchematronRulesStatePipeline generationPipeline;
    private final RulesStateCache rulesStateCache = new RulesStateCache();

    public SchematronRulesStateSource(SchematronTransformerFactory transformerFactory, SchematronTransformerParams transformerParams, RuleGeneratorParams ruleGeneratorParams, ByteCodeGenerator byteCodeGenerator, ClassGenerator classGenerator, String schematronFileDirpath, String schemaFileDirpath) {
        this.schematronFileDirpath = schematronFileDirpath;
        this.schemaFileDirpath = schemaFileDirpath;
        this.generationPipeline = new SchematronRulesStatePipeline(transformerFactory, transformerParams, byteCodeGenerator, classGenerator, ruleGeneratorParams);
    }

    public SchematronRulesStateSource(RuleGeneratorParams ruleGeneratorParams, SchematronTransformerParams schematronTransformerParams) {
        this(new SchematronTransformerFactoryImpl(), schematronTransformerParams, ruleGeneratorParams, new JDTByteCodeGenerator(ruleGeneratorParams), new ClassGeneratorImpl(), ruleGeneratorParams.getSchematronFileDirpath(), ruleGeneratorParams.getSchemaFileDirpath());
    }

    public RefreshAwareReader<RulesState> getRulesStateReader() {
        logger.fine("Getting latest rules");
        RulesState rulesState = null;
        boolean wasRulesStateRefreshed = false;
        try {
            RulesStateCacheEntry<?> latestRulesStateEntry = this.getLatestRulesStateEntry();
            wasRulesStateRefreshed = this.rulesStateCache.populateEntryWithLatestRulesState(latestRulesStateEntry);
            rulesState = (RulesState)latestRulesStateEntry.getCacheValue();
        }
        catch (RulesStateCacheException srcEx) {
            throw new RuntimeException(srcEx);
        }
        return new RefreshAwareReader<RulesState>(rulesState, wasRulesStateRefreshed);
    }

    private RulesStateCacheEntry<?> getLatestRulesStateEntry() {
        SchematronRulesStateCacheKey rulesStateCacheKey = new SchematronRulesStateCacheKey(this.schematronFileDirpath, this.schemaFileDirpath);
        SchematronRulesStateCacheEntry rulesStateCacheEntry = new SchematronRulesStateCacheEntry(rulesStateCacheKey, this.generationPipeline);
        return rulesStateCacheEntry;
    }
}

