/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.ruleUnit;

import com.gsl.io.core.stream.Streamable;
import com.gsl.schematron.transformer.SchematronResource;
import com.gsl.schematron.validator.artefacts.Artefact;
import com.gsl.schematron.validator.artefacts.ArtefactVersionManifestBuilder;
import com.gsl.schematron.validator.ruleUnit.RuleUnit;
import com.gsl.schematron.validator.ruleUnit.RuleUnitProcessor;
import java.io.IOException;
import java.util.Set;
import xmldoc.util.EntityResolutionMapBuilder;

public class RuleUnitProcessorImpl
implements RuleUnitProcessor {
    private final EntityResolutionMapBuilder mapBuilder;
    private final Set<SchematronResource> schematronResources;
    private final ArtefactVersionManifestBuilder manifestBuilder;
    private final Set<Streamable> relativeLocatorStreams;

    public RuleUnitProcessorImpl(EntityResolutionMapBuilder mapBuilder, Set<SchematronResource> schematronResources, ArtefactVersionManifestBuilder manifestBuilder, Set<Streamable> relativeLocatorStreams) {
        this.mapBuilder = mapBuilder;
        this.schematronResources = schematronResources;
        this.manifestBuilder = manifestBuilder;
        this.relativeLocatorStreams = relativeLocatorStreams;
    }

    @Override
    public void processSchema(RuleUnit ruleUnit, Artefact schemaArtefact) throws IOException {
        String uri = schemaArtefact.getNamespace().getNamespace();
        String path = schemaArtefact.getFullName();
        this.mapBuilder.add(uri, path);
        this.mapBuilder.add(uri, schemaArtefact);
        this.manifestBuilder.add(schemaArtefact);
    }

    @Override
    public void processSchematron(RuleUnit ruleUnit, Artefact schematronArtefact) throws IOException {
        SchematronResource resource = new SchematronResource(schematronArtefact, ruleUnit.generateJavaPackageName());
        this.schematronResources.add(resource);
        this.manifestBuilder.add(schematronArtefact);
    }

    @Override
    public void processRelativeLocator(RuleUnit ruleUnit, Artefact rlocArtefact) throws IOException {
        this.relativeLocatorStreams.add(rlocArtefact);
        this.manifestBuilder.add(rlocArtefact);
    }
}

