/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.ruleUnit;

import com.gsl.schematron.validator.artefacts.AbstractRuleUnit;
import com.gsl.schematron.validator.artefacts.Artefact;
import com.gsl.schematron.validator.artefacts.ArtefactProcessor;
import com.gsl.schematron.validator.artefacts.ArtefactRepository;
import com.gsl.schematron.validator.artefacts.ArtefactServiceDecorator;
import com.gsl.schematron.validator.artefacts.ArtefactVersion;
import com.gsl.schematron.validator.artefacts.FileArtefactRepository;
import com.gsl.schematron.validator.ruleUnit.PairedRuleUnit;
import com.gsl.schematron.validator.ruleUnit.RelativeLocatorRuleUnit;
import com.gsl.schematron.validator.ruleUnit.RuleUnit;
import com.gsl.schematron.validator.ruleUnit.RuleUnitProcessor;
import com.gsl.schematron.validator.ruleUnit.RuleUnitRepository;
import com.gsl.schematron.validator.ruleUnit.SchemaRuleUnit;
import com.gsl.schematron.validator.ruleUnit.SchematronRuleUnit;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class RuleUnitRepositoryImpl
implements RuleUnitRepository {
    private static final Logger logger = Logger.getLogger("RuleUnitRepository");
    private final ArtefactRepository artefactRepository;

    public RuleUnitRepositoryImpl(ArtefactRepository artefactRepository) {
        this.artefactRepository = artefactRepository;
    }

    public RuleUnitRepositoryImpl(Set<File> dirsToSearch) throws IOException {
        this.artefactRepository = new FileArtefactRepository(dirsToSearch);
    }

    @Override
    public Set<RuleUnit> getRuleUnits() {
        Set<Artefact> artefacts = this.artefactRepository.getArtefacts();
        HashSet<Artefact> schemas = new HashSet<Artefact>();
        HashSet<Artefact> schematrons = new HashSet<Artefact>();
        HashSet<Artefact> relativeLocators = new HashSet<Artefact>();
        for (Artefact artefact : artefacts) {
            if (artefact.getName().endsWith(".xsd")) {
                schemas.add(artefact);
                continue;
            }
            if (artefact.getName().endsWith(".sch")) {
                schematrons.add(artefact);
                continue;
            }
            if (!artefact.getName().endsWith(".rloc")) continue;
            relativeLocators.add(artefact);
        }
        return this.makeRuleUnits(schemas, schematrons, relativeLocators);
    }

    private Set<RuleUnit> makeRuleUnits(Set<Artefact> schemas, Set<Artefact> schematrons, Set<Artefact> relativeLocators) {
        HashSet<RuleUnit> result = new HashSet<RuleUnit>();
        HashMap<String, Artefact> usedNamespaces = new HashMap<String, Artefact>();
        Set<ArtefactServiceDecorator> decoratedSchemas = ArtefactServiceDecorator.decorateArtefacts(schemas);
        Set<ArtefactServiceDecorator> decoratedSchematrons = ArtefactServiceDecorator.decorateArtefacts(schematrons);
        Iterator<ArtefactServiceDecorator> schematronIterator = decoratedSchematrons.iterator();
        block0: while (schematronIterator.hasNext()) {
            ArtefactServiceDecorator schematron = schematronIterator.next();
            Iterator<ArtefactServiceDecorator> schemaIterator = decoratedSchemas.iterator();
            while (schemaIterator.hasNext()) {
                Artefact previousArtefact;
                ArtefactServiceDecorator schema = schemaIterator.next();
                ArtefactVersion schemaVersion = schema.getVersion();
                ArtefactVersion schematronVersion = schematron.getVersion();
                if (!schema.getService().equals(schematron.getService()) || !schemaVersion.equals(schematronVersion)) continue;
                PairedRuleUnit newRuleUnit = new PairedRuleUnit(schema.getArtefact(), schematron.getArtefact(), schema.getService(), schemaVersion);
                if (!this.detectConflict(result, newRuleUnit)) {
                    result.add(newRuleUnit);
                }
                schemaIterator.remove();
                schematronIterator.remove();
                String namespace = schema.getArtefact().getNamespace().getNamespace();
                if (usedNamespaces.containsKey(namespace) && !(previousArtefact = (Artefact)usedNamespaces.get(namespace)).getName().equals(schema.getArtefact().getName())) {
                    throw new RuntimeException("Namespace " + namespace + " has been declared in multiple schema/schematron pairs");
                }
                usedNamespaces.put(namespace, schema.getArtefact());
                continue block0;
            }
        }
        for (ArtefactServiceDecorator decoratedSchema : decoratedSchemas) {
            SchemaRuleUnit newRuleUnit;
            if (usedNamespaces.containsKey(decoratedSchema.getArtefact().getNamespace().getNamespace()) || this.detectConflict(result, newRuleUnit = new SchemaRuleUnit(decoratedSchema.getArtefact(), decoratedSchema.getService(), decoratedSchema.getVersion()))) continue;
            result.add(newRuleUnit);
        }
        for (ArtefactServiceDecorator artefact : decoratedSchematrons) {
            result.add(new SchematronRuleUnit(artefact.getArtefact(), artefact.getService(), artefact.getVersion()));
        }
        for (Artefact rlocArtefact : relativeLocators) {
            result.add(new RelativeLocatorRuleUnit(rlocArtefact));
        }
        return result;
    }

    private boolean detectConflict(Set<RuleUnit> result, AbstractRuleUnit newRuleUnit) {
        boolean conflict = false;
        Iterator<RuleUnit> resultsIter = result.iterator();
        while (resultsIter.hasNext()) {
            RuleUnit resultEntry = resultsIter.next();
            if (!newRuleUnit.getServiceName().equals(resultEntry.getServiceName()) || !newRuleUnit.getNamespace().equals(resultEntry.getNamespace())) continue;
            conflict = true;
            if (newRuleUnit.compareTo(resultEntry) <= 0) continue;
            resultsIter.remove();
            result.add(newRuleUnit);
            break;
        }
        return conflict;
    }

    @Override
    public long getChecksum() {
        return this.artefactRepository.getChecksum();
    }

    @Override
    public void processRuleUnits(RuleUnitProcessor processor) throws IOException {
        for (RuleUnit ruleUnit : this.getRuleUnits()) {
            ruleUnit.process(processor);
        }
    }

    @Override
    public void processArtefacts(ArtefactProcessor processor) {
        this.artefactRepository.processArtefacts(processor);
    }
}

