/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.util;

import com.gsl.util.ComparatorMap;
import com.gsl.util.CompositeComparatorBuilder;
import com.gsl.util.FilepathComparator;
import com.gsl.util.HashCode;
import com.gsl.util.LastModifiedComparator;
import com.gsl.util.ObjectUtil;
import com.gsl.util.ReversibleComparator;
import com.gsl.util.version.Version;
import com.gsl.util.version.Versioned;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;

public class FileDescriptor
implements Serializable,
Versioned,
Comparable<FileDescriptor> {
    public static final int FILEPATH_ID = 0;
    public static final int LAST_MODIFIED_ID = 1;
    private static ComparatorMap<FileDescriptor> COMPARATOR_MAP = new ComparatorMap();
    private static Comparator<FileDescriptor> FILEPATH_LAST_MODIFIED_COMPARATOR;
    private final String filepath;
    private final String filename;
    private final Date lastModified;
    private final Version version;
    private final int hashCode;

    public static Comparator<FileDescriptor> getComparator(int id, int direction) {
        ReversibleComparator<FileDescriptor> comparator = COMPARATOR_MAP.get(id, direction);
        if (comparator == null) {
            switch (id) {
                default: {
                    comparator = new FilepathComparator(direction);
                    break;
                }
                case 1: {
                    comparator = new LastModifiedComparator(direction);
                }
            }
            COMPARATOR_MAP.add(id, direction, comparator);
        }
        return comparator;
    }

    public FileDescriptor(String filepath, Date lastModified, Version version) {
        this.filepath = filepath;
        int filepathSeparatorPos = filepath.lastIndexOf(System.getProperty("file.separator"));
        this.filename = filepathSeparatorPos != -1 ? filepath.substring(filepathSeparatorPos + 1) : "";
        this.lastModified = lastModified;
        this.version = version;
        this.hashCode = this.calculateHashCode();
    }

    public FileDescriptor(String filepath, String filename) {
        this.filepath = filepath;
        this.filename = filename;
        this.lastModified = null;
        this.version = VERSION_IF_NONE_SPECIFIED;
        this.hashCode = this.calculateHashCode();
    }

    public FileDescriptor(String filepath, Date lastModified) {
        this(filepath, lastModified, VERSION_IF_NONE_SPECIFIED);
    }

    public FileDescriptor(String filepath) {
        this(filepath, (Date)null);
    }

    private int calculateHashCode() {
        int result = 23;
        result = HashCode.hash(result, this.filepath);
        result = HashCode.hash(result, this.lastModified);
        result = HashCode.hash(result, this.version);
        return result;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFilenameExtension() {
        int periodPos = this.filename.lastIndexOf(46);
        String fileNameExtension = periodPos != -1 ? this.filename.substring(periodPos + 1) : "";
        return fileNameExtension;
    }

    public Date getLastModifiedDate() {
        return this.lastModified;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return this.filepath + " (" + this.lastModified + ", " + this.version.toString() + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        boolean equals = false;
        if (rhs != null && rhs.getClass() == FileDescriptor.class) {
            FileDescriptor fd = (FileDescriptor)rhs;
            equals = this.filepath.equals(fd.filepath) && ObjectUtil.nullSafeEquals(this.lastModified, fd.lastModified) && this.version.equals(fd.version);
        }
        return equals;
    }

    @Override
    public int compareTo(FileDescriptor o) {
        return FILEPATH_LAST_MODIFIED_COMPARATOR.compare(this, o);
    }

    static {
        CompositeComparatorBuilder<FileDescriptor> builder = new CompositeComparatorBuilder<FileDescriptor>();
        builder.add(FileDescriptor.getComparator(0, 0));
        builder.add(FileDescriptor.getComparator(1, 0));
        FILEPATH_LAST_MODIFIED_COMPARATOR = builder.makeCompositeComparator();
    }
}

