/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.util;

import java.lang.reflect.Array;

public final class HashCode {
    public static final int SEED = 23;
    private static final int fODD_PRIME_NUMBER = 37;

    public static int hash(int aSeed, boolean aBoolean) {
        return HashCode.firstTerm(aSeed) + (aBoolean ? 1 : 0);
    }

    public static int hash(int aSeed, char aChar) {
        return HashCode.firstTerm(aSeed) + aChar;
    }

    public static int hash(int aSeed, int aInt) {
        return HashCode.firstTerm(aSeed) + aInt;
    }

    public static int hash(int aSeed, long aLong) {
        return HashCode.firstTerm(aSeed) + (int)(aLong ^ aLong >>> 32);
    }

    public static int hash(int aSeed, float aFloat) {
        return HashCode.hash(aSeed, Float.floatToIntBits(aFloat));
    }

    public static int hash(int aSeed, double aDouble) {
        return HashCode.hash(aSeed, Double.doubleToLongBits(aDouble));
    }

    public static int hash(int aSeed, Object aObject) {
        int result = aSeed;
        if (aObject == null) {
            result = HashCode.hash(result, 0);
        } else if (!HashCode.isArray(aObject)) {
            result = HashCode.hash(result, aObject.hashCode());
        } else {
            int length = Array.getLength(aObject);
            for (int idx = 0; idx < length; ++idx) {
                Object item = Array.get(aObject, idx);
                result = HashCode.hash(result, item);
            }
        }
        return result;
    }

    private static int firstTerm(int aSeed) {
        return 37 * aSeed;
    }

    private static boolean isArray(Object aObject) {
        return aObject.getClass().isArray();
    }
}

