/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.util;

import com.gsl.util.LoadableSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public abstract class PropertiesLoadableSupport
extends LoadableSupport {
    @Override
    public void load(InputStream is) throws IOException {
        Properties p = new Properties();
        p.load(is);
        this.load(p);
    }

    public abstract void load(Properties var1);

    public static String getString(Properties p, String key) {
        return PropertiesLoadableSupport.getString(p, key, null);
    }

    public static String getString(Properties p, String key, String def) {
        return p.getProperty(key, def);
    }

    public static long getInteger(Properties p, String key) {
        return PropertiesLoadableSupport.getInteger(p, key, 0L);
    }

    public static long getInteger(Properties p, String key, long def) {
        String val = p.getProperty(key);
        return val != null ? Long.parseLong(val) : def;
    }

    public static double getFloat(Properties p, String key) {
        return PropertiesLoadableSupport.getFloat(p, key, 0.0);
    }

    public static double getFloat(Properties p, String key, double def) {
        String val = p.getProperty(key);
        return val != null ? Double.parseDouble(val) : def;
    }

    public static boolean getBoolean(Properties p, String key) {
        return PropertiesLoadableSupport.getBoolean(p, key, false);
    }

    public static boolean getBoolean(Properties p, String key, boolean def) {
        String val = p.getProperty(key);
        return val != null ? Boolean.valueOf(val) : def;
    }
}

