/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.util.classlookup;

import com.gsl.util.classlookup.ClassNameCollector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CachingClassCollector
implements ClassNameCollector {
    private static final Map<String, Collection<String>> cache = new HashMap<String, Collection<String>>();
    private final ClassNameCollector collector;
    private final String cacheKey;

    public CachingClassCollector(ClassNameCollector collector) {
        this.collector = collector;
        this.cacheKey = collector.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> collectClassNames() {
        Collection<String> classes;
        Map<String, Collection<String>> map = cache;
        synchronized (map) {
            classes = cache.get(this.cacheKey);
            if (classes == null) {
                classes = this.collectClassesToCache();
                cache.put(this.cacheKey, classes);
            }
        }
        return classes;
    }

    protected Collection<String> collectClassesToCache() {
        return this.collector.collectClassNames();
    }
}

