/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.util.classlookup;

import com.gsl.util.classlookup.CachingClassCollector;
import com.gsl.util.classlookup.ClassCollector;
import com.gsl.util.classlookup.ClassNameCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

public class CachingClassInstanceCollector
extends CachingClassCollector
implements ClassCollector {
    private static final Logger logger = Logger.getLogger("util.classlookup");

    public CachingClassInstanceCollector(ClassNameCollector collector) {
        super(collector);
    }

    @Override
    public Collection<Class<?>> collectClasses() {
        Collection<String> classNames = this.collectClassNames();
        ArrayList classes = new ArrayList(classNames.size());
        for (String className : classNames) {
            try {
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                logger.warning("Could not find class " + className);
            }
        }
        return classes;
    }
}

