/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.util.classlookup;

import com.gsl.util.classlookup.ClassNameCollector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassPathClassCollector
implements ClassNameCollector {
    static final int SUFFIX_LENGTH = ".class".length();
    private final boolean catchFileNotFoundFix = false;

    @Override
    public Collection<String> collectClassNames() {
        String classPath = System.getProperty("java.class.path");
        Map<String, String> result = this.collectFilesInPath(classPath);
        return result.values();
    }

    public Map<String, String> collectFilesInPath(String classPath) {
        Map<String, String> result = this.collectFilesInRoots(this.splitClassPath(classPath));
        return result;
    }

    Map<String, String> collectFilesInRoots(List<String> roots) {
        Hashtable<String, String> result = new Hashtable<String, String>(100);
        for (String nextRoot : roots) {
            if (nextRoot.endsWith(".jar")) {
                this.gatherJarFileEntries(nextRoot, result);
                continue;
            }
            this.gatherFiles(new File(nextRoot), "", result);
        }
        return result;
    }

    private void gatherJarFileEntries(String classRoot, Map<String, String> result) {
        try {
            JarFile jarFile = new JarFile(classRoot);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!this.isMatchingClass(entryName)) continue;
                String className = this.classNameFromFile(entryName);
                result.put(className, className);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void gatherFiles(File classRoot, String classFileName, Map<String, String> result) {
        File thisRoot = new File(classRoot, classFileName);
        if (thisRoot.isFile()) {
            if (this.isMatchingClass(classFileName)) {
                String className = this.classNameFromFile(classFileName);
                result.put(className, className);
            }
            return;
        }
        if (thisRoot.isDirectory()) {
            try {
                String[] contents = thisRoot.list();
                if (contents != null) {
                    for (String element : contents) {
                        this.gatherFiles(classRoot, classFileName + File.separatorChar + element, result);
                    }
                }
            }
            catch (FileNotFoundException t) {
                // empty catch block
            }
        }
    }

    List<String> splitClassPath(String classPath) {
        ArrayList<String> result = new ArrayList<String>();
        String separator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(classPath, separator);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    protected boolean isMatchingClass(String classFileName) {
        return classFileName.endsWith(".class") && classFileName.indexOf(36) < 0;
    }

    protected String classNameFromFile(String classFileName) {
        String s = classFileName.substring(0, classFileName.length() - SUFFIX_LENGTH);
        String s2 = s.replace(File.separatorChar, '.');
        if ((s2 = s2.replace('/', '.')).startsWith(".")) {
            return s2.substring(1);
        }
        return s2;
    }
}

