/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.util.classlookup;

import com.gsl.logging.LoggerFactory;
import com.gsl.util.classlookup.PackageClassCollector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class InterfaceInstanceCollector
extends PackageClassCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger("class.collector");
    private final Class<?> implementsInterface;
    private final String stringName;

    public InterfaceInstanceCollector(String basePackageName, Class<?> implementsInterface) {
        super(basePackageName);
        this.stringName = "InterfaceInstanceCollector [basePackageName='" + basePackageName + "', interfaceCollector=" + implementsInterface.getName() + "]";
        this.implementsInterface = implementsInterface;
    }

    @Override
    protected boolean isMatchingClass(String classFileName) {
        boolean result = false;
        if (super.isMatchingClass(classFileName)) {
            String className = this.classNameFromFile(classFileName);
            try {
                Class<?> clazz = Class.forName(className);
                if (Modifier.isPublic(clazz.getModifiers()) && !Modifier.isAbstract(clazz.getModifiers())) {
                    result = this.checkImplementsInterface(clazz);
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.info("class not found attempting to load: " + className + ": ");
            }
            catch (SecurityException se) {
                LOGGER.info("security exception attempting to load: " + className + ": ");
            }
            catch (Throwable t) {
                LOGGER.severe("failed to load class: " + className + ": " + t.getMessage());
            }
        }
        return result;
    }

    public String toString() {
        return this.stringName;
    }

    private boolean checkImplementsInterface(Class<?> clazz) {
        boolean result = false;
        List<Class<?>> interfaces = this.getInterfaces(clazz);
        if (interfaces.contains(this.implementsInterface)) {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
                result = true;
            }
        }
        return result;
    }

    private List<Class<?>> getInterfaces(Class<?> clazz) {
        ArrayList result = new ArrayList();
        for (Class<?> classToCheck = clazz; classToCheck != null; classToCheck = classToCheck.getSuperclass()) {
            Class<?>[] interfaces;
            for (Class<?> element : interfaces = classToCheck.getInterfaces()) {
                result.add(element);
            }
        }
        return result;
    }
}

