/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.util.classlookup;

import com.gsl.util.classlookup.ClassNameCollector;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class PropertiesFileClassCollector
implements ClassNameCollector {
    private final String propertiesFileName;

    public PropertiesFileClassCollector(String basePackageName) {
        this(basePackageName, null);
    }

    public PropertiesFileClassCollector(String basePackageName, Class<?> typeToFind) {
        this.propertiesFileName = PropertiesFileClassCollector.createPropertiesPathAndFilename(basePackageName, typeToFind);
    }

    @Override
    public Collection<String> collectClassNames() {
        InputStream is = this.getClass().getResourceAsStream(this.propertiesFileName);
        Properties properties = new Properties();
        try {
            if (is != null) {
                properties.load(is);
                is.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashSet<String> classNames = new HashSet<String>();
        Set<Object> names = properties.keySet();
        for (Object name : names) {
            classNames.add((String)name);
        }
        return Collections.unmodifiableSet(classNames);
    }

    public static String createPropertiesPathAndFilename(String basePackageName, Class<?> typeToFind) {
        String typeName = "";
        if (typeToFind != null) {
            typeName = typeToFind.getSimpleName();
        }
        String pathName = "/" + basePackageName.replace('.', '/');
        String filename = pathName + "/" + "Collected" + typeName + ".properties";
        return filename;
    }
}

