/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.util.classlookup;

import com.gsl.logging.LoggerFactory;
import com.gsl.util.classlookup.ClassCollector;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;

public class PropertiesFileClassCollector2
implements ClassCollector {
    private static final Logger log = LoggerFactory.getLogger("com.gsl.util.classlookup");
    private final String propertiesFileName;

    public PropertiesFileClassCollector2(String basePackageName) {
        this(basePackageName, null);
    }

    public PropertiesFileClassCollector2(String basePackageName, Class<?> typeToFind) {
        this.propertiesFileName = this.createPropertiesPathAndFilename(basePackageName, typeToFind);
    }

    public Collection collectClasses() {
        try {
            Properties properties = new Properties();
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources(this.propertiesFileName);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream is = url.openStream();
                properties.load(is);
                is.close();
            }
            if (properties.isEmpty()) {
                log.warning("no classes found for: '" + this.propertiesFileName + "'");
            }
            return properties.keySet();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String createPropertiesPathAndFilename(String basePackageName, Class<?> typeToFind) {
        String typeName = "";
        if (typeToFind != null) {
            typeName = typeToFind.getSimpleName();
        }
        String pathName = basePackageName.replace('.', '/');
        String filename = pathName + "/" + "Collected" + typeName + ".properties";
        return filename;
    }
}

