/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.util.classlookup;

import com.gsl.util.classlookup.InterfaceInstanceCollector;
import com.gsl.util.classlookup.PropertiesFileClassCollector;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.TreeSet;

public class PropertiesFileGenerator {
    public static void main(String[] args) {
        try {
            for (int i = 0; i <= args.length - 3; i += 3) {
                String basePackageName = args[i];
                Class<?> typeToFind = Class.forName(args[i + 1]);
                String outputFileName = args[i + 2];
                if (outputFileName == null || outputFileName.length() == 0) {
                    outputFileName = PropertiesFileClassCollector.createPropertiesPathAndFilename(basePackageName, typeToFind).substring(1);
                }
                System.out.println("Writing classes to properties file:");
                System.out.println(" basePackageName=" + basePackageName);
                System.out.println(" typeToFind=" + typeToFind.getName());
                System.out.println(" outputFileName=" + outputFileName);
                int numClasses = PropertiesFileGenerator.writeClassesToPropertiesFile(basePackageName, typeToFind, outputFileName);
                System.out.println();
                System.out.println("Wrote " + numClasses + " classes.");
                System.out.println();
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int writeClassesToPropertiesFile(String basePackageName, Class<?> typeToFind, String outputFileName) throws IOException {
        InterfaceInstanceCollector collector = new InterfaceInstanceCollector(basePackageName, typeToFind);
        TreeSet<String> classes = new TreeSet<String>(collector.collectClassNames());
        FileWriter writer = new FileWriter(outputFileName);
        for (Object e : classes) {
            writer.write((String)e);
            writer.write("=\n");
        }
        ((Writer)writer).close();
        return classes.size();
    }

    public static void writeClassesToPropertiesFile(String[][] packagesToCollect) {
        for (String[] element : packagesToCollect) {
            String className = element[1];
            try {
                Class<?> typeToFind = Class.forName(className);
                PropertiesFileGenerator.writeClassesToPropertiesFile(element[0], typeToFind, element[2]);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

