/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.util.reflection;

import com.gsl.util.cache.AbstractCache;
import com.gsl.util.collections.NestedHashMapTwoKeyMap;
import com.gsl.util.collections.TwoKeyMap;
import com.gsl.util.reflection.MethodLocator;
import com.gsl.util.reflection.MethodLocatorCacheEntry;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class MethodLocatorCache
extends AbstractCache
implements MethodLocator {
    private final MethodLocator chainedMethodLocator;
    private final Map<ClassLoader, TwoKeyMap<Class<?>, String, MethodLocatorCacheEntry>> cache = new HashMap();

    public MethodLocatorCache(MethodLocator chainedMethodLocator) {
        this.chainedMethodLocator = chainedMethodLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Method locateMethod(Class<?> clazz, String methodName) {
        Map<ClassLoader, TwoKeyMap<Class<?>, String, MethodLocatorCacheEntry>> map = this.cache;
        synchronized (map) {
            MethodLocatorCacheEntry entry;
            ClassLoader classloader = clazz.getClassLoader();
            TwoKeyMap<Class<?>, String, MethodLocatorCacheEntry> map2 = this.cache.get(classloader);
            if (map2 == null) {
                map2 = new NestedHashMapTwoKeyMap();
                this.cache.put(classloader, map2);
            }
            if ((entry = map2.get(clazz, methodName)) == null) {
                this.miss();
                Method method = this.chainedMethodLocator.locateMethod(clazz, methodName);
                if (method != null) {
                    entry = new MethodLocatorCacheEntry(method);
                    map2.put(clazz, methodName, entry);
                } else {
                    entry = MethodLocatorCacheEntry.NullPlaceholder;
                    map2.put(clazz, methodName, entry);
                }
            } else {
                this.hit();
            }
            return entry.getMethod();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Map<ClassLoader, TwoKeyMap<Class<?>, String, MethodLocatorCacheEntry>> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(ClassLoader classloader) {
        Map<ClassLoader, TwoKeyMap<Class<?>, String, MethodLocatorCacheEntry>> map = this.cache;
        synchronized (map) {
            TwoKeyMap<Class<?>, String, MethodLocatorCacheEntry> map2 = this.cache.get(classloader);
            if (map2 != null) {
                map2.clear();
            }
        }
    }
}

