/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.util.reflection;

import com.gsl.util.reflection.BasicMethodLocator;
import com.gsl.util.reflection.MethodLocator;
import java.lang.reflect.Method;

public class SetterMethodLocator
implements MethodLocator {
    private final MethodLocator chainedMethodLocator;

    public SetterMethodLocator(Class<?> argType) {
        this(new Class[]{argType});
    }

    public SetterMethodLocator(Class<?>[] argTypes) {
        this.chainedMethodLocator = new BasicMethodLocator(argTypes, Void.TYPE);
    }

    public SetterMethodLocator(MethodLocator chainedMethodLocator) {
        this.chainedMethodLocator = chainedMethodLocator;
    }

    @Override
    public Method locateMethod(Class<?> clazz, String propertyName) {
        String setterName = SetterMethodLocator.makeSetterName(propertyName);
        return this.chainedMethodLocator.locateMethod(clazz, setterName);
    }

    private static String makeSetterName(String name) throws IllegalArgumentException {
        String result = "";
        if (name == null) {
            throw new IllegalArgumentException("name should not be null in makeSetterName");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("name should not be blank in makeSetterName");
        }
        String firstChar = name.substring(0, 1).toUpperCase();
        String rest = name.substring(1);
        result = "set" + firstChar + rest;
        return result;
    }
}

