/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xs;

import com.gsl.logging.LoggerFactory;
import com.gsl.xs.NullSchemaModelFactory;
import com.gsl.xs.SchemaModelFactory;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import xmldoc.util.EntityResolver;

public final class SchemaModelUtil {
    private static final Logger log = LoggerFactory.getLogger(SchemaModelUtil.class.getName());
    private static final String DEFAULT_FACTORY_IMPL = "com.gsl.xs.impl.XsdSchemaModelFactory";

    private SchemaModelUtil() {
    }

    public static SchemaModelFactory createDefaultSchemaModelFactory(EntityResolver resolver) {
        SchemaModelFactory factory = null;
        if (resolver != null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_FACTORY_IMPL);
                Constructor<?> constructor = clazz.getConstructor(EntityResolver.class);
                factory = (SchemaModelFactory)constructor.newInstance(resolver);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "failed to create schema model factory.  this feature will be disabled", e);
            }
        }
        if (factory == null) {
            factory = NullSchemaModelFactory.INSTANCE;
        }
        return factory;
    }
}

