/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xs;

import com.gsl.xs.XLocatorParser;
import com.gsl.xs.XLocatorStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class XLocator
implements Iterable<XLocatorStep> {
    private static final List<XLocatorStep> EMPTY_STEPS_LIST = Collections.emptyList();
    public static final XLocator ROOT = new XLocator(Arrays.asList(XLocatorStep.ROOT), false);
    public static final XLocator DOT = new XLocator(EMPTY_STEPS_LIST, true);
    private final List<XLocatorStep> steps;
    private final boolean relative;
    private int uniqueNamespaceCount = -1;
    private int hashCode = 0;

    public static XLocator create(String path) {
        if ((path = path.trim()).length() == 0) {
            throw new IllegalArgumentException("empty string is not a valid path");
        }
        boolean relative = path.charAt(0) != '/';
        LinkedList<XLocatorStep> parsedSteps = new LinkedList<XLocatorStep>();
        for (Object step : XLocatorParser.splitPath(path)) {
            parsedSteps.add(XLocatorStep.create(step));
        }
        List<XLocatorStep> steps = XLocator.collapse(parsedSteps);
        return XLocator.create(steps, relative);
    }

    @Override
    public Iterator<XLocatorStep> iterator() {
        return this.steps.iterator();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean stripAttribute) {
        if (this == DOT) {
            return ".";
        }
        if (this == ROOT) {
            return "/";
        }
        StringBuffer buf = new StringBuffer(64);
        if (!this.isRelative()) {
            buf.append('/');
        }
        for (XLocatorStep step : this) {
            if (stripAttribute && step.isAttr()) continue;
            buf.append(step).append('/');
        }
        buf.setLength(buf.length() - 1);
        return buf.toString();
    }

    public String toBindingString() {
        return this.toString(true);
    }

    public boolean isRelative() {
        return this.relative;
    }

    public boolean isAbsolute() {
        return !this.relative;
    }

    public int size() {
        return this.steps.size();
    }

    public int uniqueNamespaceCount() {
        if (this.uniqueNamespaceCount == -1) {
            HashSet<String> prefixes = new HashSet<String>();
            for (XLocatorStep step : this) {
                if (step.getPrefix() == "") continue;
                prefixes.add(step.getPrefix());
            }
            this.uniqueNamespaceCount = prefixes.size();
        }
        return this.uniqueNamespaceCount;
    }

    public XLocator raiseBy(int n) {
        if (!this.isRelative()) {
            throw new IllegalArgumentException("locator must be relative to raise it");
        }
        if (n < 0) {
            return this.lowerBy(-n);
        }
        LinkedList<XLocatorStep> steps = new LinkedList<XLocatorStep>(this.steps);
        for (int i = 0; i < n; ++i) {
            steps.addFirst(XLocatorStep.DOT_DOT);
        }
        return XLocator.create(steps, true);
    }

    public XLocator lowerBy(int n) {
        if (!this.isRelative()) {
            throw new IllegalArgumentException("locator must be relative to lower it");
        }
        if (n < 0) {
            return this.raiseBy(-n);
        }
        return this.subPath(n, this.size());
    }

    public int top() {
        return !this.isRelative() ? 0 : this._count(0);
    }

    public int reach() {
        return !this.isRelative() ? this.size() : this._count(1);
    }

    public XLocatorStep getStep(int index) {
        if (index < 0) {
            index += this.size();
        }
        return this.steps.get(index);
    }

    public List<XLocatorStep> getSteps() {
        return this.steps;
    }

    public XLocatorStep getFirstStep() {
        if (this.steps.size() > 0) {
            return this.steps.get(0);
        }
        return null;
    }

    public XLocatorStep getLastStep() {
        if (this.steps.size() > 0) {
            return this.steps.get(this.steps.size() - 1);
        }
        return null;
    }

    public XLocator dropLastStep() {
        if (this.steps.size() > 0) {
            return new XLocator(this.steps.subList(0, this.steps.size() - 1), this.relative);
        }
        return this;
    }

    public XLocator dropFirstStep() {
        if (this.steps.size() > 0) {
            List<XLocatorStep> newSteps = this.steps.subList(1, this.steps.size());
            if (newSteps.size() == 0) {
                return DOT;
            }
            return new XLocator(newSteps, this.relative);
        }
        return this;
    }

    public XLocator append(XLocator loc) {
        if (!loc.isRelative()) {
            throw new IllegalArgumentException("cannot append an absolute locator");
        }
        if (this.isAttr()) {
            throw new IllegalArgumentException("cannot append to an attribute locator");
        }
        if (loc == DOT) {
            return this;
        }
        if (this == DOT) {
            return loc;
        }
        LinkedList<XLocatorStep> appendedSteps = new LinkedList<XLocatorStep>(this.steps);
        appendedSteps.addAll(loc.steps);
        List<XLocatorStep> steps = XLocator.collapse(appendedSteps);
        return XLocator.create(steps, this.relative);
    }

    public boolean isSubPathOf(XLocator loc) {
        if (this.isRelative() || loc.isRelative()) {
            throw new IllegalArgumentException("locators must be absolute to determine if one is a subpath of the other");
        }
        if (this.equals(loc)) {
            return true;
        }
        if (this.size() > loc.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.getStep(i).equals(loc.getStep(i))) continue;
            return false;
        }
        return true;
    }

    public XLocator commonRootWith(XLocator loc) {
        int index;
        if (this.isRelative() || loc.isRelative()) {
            throw new IllegalArgumentException("locator must be absolute to find common root");
        }
        for (index = 0; index < this.size() && index < loc.size() && this.getStep(index).equals(loc.getStep(index)); ++index) {
        }
        return this.subPath(index);
    }

    public XLocator relativeTo(XLocator loc) {
        if (loc.isAttr() && this.size() == 2 && this.getFirstStep() == XLocatorStep.DOT_DOT) {
            return loc.stripAttr().append(this.dropFirstStep());
        }
        return this.isRelative() ? loc.stripAttr().append(this) : this;
    }

    public XLocator subPath(int index) {
        if (this.isRelative()) {
            throw new IllegalArgumentException("locator must be absolute to form sub path");
        }
        if (index < 0) {
            index += this.size();
        }
        return this.subPath(0, index);
    }

    public XLocator stripAttr() {
        if (!this.isAttr()) {
            return this;
        }
        return this.subPath(0, this.size() - 1);
    }

    public boolean isAttr() {
        return this.size() > 0 && this.getStep(-1).isAttr();
    }

    private static XLocator create(List<XLocatorStep> steps, boolean relative) {
        if (steps.isEmpty()) {
            return relative ? DOT : ROOT;
        }
        return new XLocator(steps, relative);
    }

    public XLocator subPath(int start, int end) {
        if (start == end) {
            return this.relative ? DOT : ROOT;
        }
        if (start == 0 && end == this.size()) {
            return this;
        }
        return new XLocator(this.steps.subList(start, end), this.relative);
    }

    private XLocator(List<XLocatorStep> steps, boolean relative) {
        if (steps != EMPTY_STEPS_LIST && steps.isEmpty()) {
            throw new IllegalArgumentException("use either ROOT or DOT constants for zero length xpaths");
        }
        this.steps = steps;
        this.relative = relative;
        this.validate();
    }

    private void validate() {
        if (!this.isRelative() && !this.steps.isEmpty() && this.getStep(0) == XLocatorStep.DOT_DOT) {
            throw new IllegalArgumentException("invalid xlocator: absolute paths cannot have leading '..' path components'" + this + "'");
        }
        Iterator<XLocatorStep> i = this.iterator();
        while (i.hasNext()) {
            XLocatorStep step = i.next();
            if (".".equals(step.getName())) {
                throw new IllegalArgumentException("invalid xlocator, unexpected '.' path component in collapsed step list (probably indicates internal bug)'" + this + "'");
            }
            if (step != XLocatorStep.DOT_DOT && "..".equals(step.getName())) {
                throw new IllegalArgumentException("invalid xlocator, unexpected '..' path component, use XLocatorStep.DOT_DOT constant (probably indicates bug in parser)'" + this + "'");
            }
            if (!step.isAttr() || !i.hasNext()) continue;
            throw new IllegalArgumentException("invalid xlocator, attribute can only be at the end of the path: '" + this + "'");
        }
    }

    private static List<XLocatorStep> collapse(LinkedList<XLocatorStep> steps) {
        int m;
        block0: do {
            int n = -1;
            m = 0;
            Iterator i = steps.iterator();
            while (i.hasNext()) {
                XLocatorStep step = (XLocatorStep)i.next();
                if (step == XLocatorStep.DOT) {
                    i.remove();
                    n = --m;
                } else if (step == XLocatorStep.DOT_DOT) {
                    if (n >= 0) {
                        i.remove();
                        steps.remove(n);
                        m = -1;
                        continue block0;
                    }
                } else {
                    n = m;
                }
                ++m;
            }
        } while (m < 0);
        return Collections.unmodifiableList(new ArrayList<XLocatorStep>(steps));
    }

    private int _count(int n) {
        int count = 0;
        for (XLocatorStep step : this) {
            count += step == XLocatorStep.DOT_DOT ? -1 : n;
        }
        return count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XLocator)) {
            return false;
        }
        XLocator other = (XLocator)o;
        return this.relative == other.relative && this.steps.equals(other.steps);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (this.relative ? 1 : 31) ^ this.steps.hashCode();
        }
        return this.hashCode;
    }
}

