/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xs;

import com.gsl.xs.XLocatorParser;
import com.gsl.xs.XPredicate;

public final class XLocatorStep {
    static final String NONE = "";
    public static final XLocatorStep DOT = new XLocatorStep("", ".", null, false);
    public static final XLocatorStep DOT_DOT = new XLocatorStep("", "..", null, false);
    public static final XLocatorStep ROOT = new XLocatorStep("", "/", null, false);
    public static final XLocatorStep CHILDREN = new XLocatorStep("", "*", null, false);
    private String prefix = "";
    private final String name;
    private final XPredicate predicate;
    private final boolean attr;
    private int hashCode = 0;

    static XLocatorStep create(Object step) {
        if (step instanceof XLocatorStep) {
            return (XLocatorStep)step;
        }
        return XLocatorParser.parseStep(step);
    }

    XLocatorStep(String prefix, String name, XPredicate predicate, boolean attr) {
        if (prefix == null) {
            throw new IllegalArgumentException("trying to set prefix to null");
        }
        this.prefix = prefix;
        this.name = name;
        this.predicate = predicate;
        this.attr = attr;
    }

    public String toString() {
        String name = this.attr ? '@' + this.name : this.name;
        return this.prefix.equals(NONE) ? name : this.prefix + ":" + name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public XPredicate getPredicate() {
        return this.predicate;
    }

    public boolean isAttr() {
        return this.attr;
    }

    public boolean equals(Object o) {
        if (!(o instanceof XLocatorStep)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        XLocatorStep other = (XLocatorStep)o;
        return this.attr == other.attr && this.name.equals(other.name) && this.prefix.equals(other.prefix);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (this.attr ? 1 : 31) ^ this.name.hashCode() ^ this.prefix.hashCode();
        }
        return this.hashCode;
    }
}

