/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xs.impl;

import com.gsl.logging.LoggerFactory;
import com.gsl.xs.SchemaModel;
import com.gsl.xs.SchemaModelPathAvailability;
import com.gsl.xs.SchemaModelPathDescriptor;
import com.gsl.xs.SchemaModelPathRelationship;
import com.gsl.xs.XLocator;
import com.gsl.xs.XLocatorStep;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.util.EntityResolverWrapper;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import xmldoc.NamespacePrefixMapper;
import xmldoc.util.EntityResolver;

class XsdSchemaModel
implements SchemaModel {
    private static final Logger logger = LoggerFactory.getLogger("schemaModel");
    private final String namespace;
    private final String root;
    private final Map<XLocator, Entry> entries = new HashMap<XLocator, Entry>();
    private SchemaModelPathDescriptor rootPathDescriptor;

    XsdSchemaModel(EntityResolver entityResolver, String namespace, String root) throws IOException, SAXException {
        this.namespace = namespace;
        this.root = root;
        this.createModelEntries(new RecursionContext(entityResolver, null, null));
    }

    XsdSchemaModel(EntityResolver entityResolver, NamespacePrefixMapper mapper, XLocator path) throws IOException, SAXException {
        XLocatorStep step = path.getStep(0);
        this.namespace = mapper.mapPrefixToNamespace(step.getPrefix());
        this.root = step.getName();
        this.createModelEntries(new RecursionContext(entityResolver, mapper, path));
    }

    private void createModelEntries(RecursionContext recursionContext) throws IOException, SAXException {
        this.processGrammar(recursionContext, this.namespace, this.root, "", new int[2]);
        this.entries.put(XLocator.ROOT, new Entry(XLocator.ROOT, true, false, false, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    private void processGrammar(RecursionContext recursionContext, String namespace, String root, String pathString, int[] order) throws IOException, SAXException {
        InputSource inputSource = recursionContext.entityResolver.resolveEntity(namespace, namespace);
        if (inputSource == null) {
            logger.severe("Could not resolve entity for namespace '" + namespace + "'");
            return;
        }
        XMLInputSource xmlInputSource = new XMLInputSource("", "/", "", inputSource.getByteStream(), null);
        XSGrammar grammar = (XSGrammar)recursionContext.loader.loadGrammar(xmlInputSource);
        XSModel xsModel = grammar.toXSModel();
        XSElementDeclaration rootElement = xsModel.getElementDeclaration(root, namespace);
        if (rootElement == null) {
            logger.warning("Could not find root element '" + root + "' in namespace '" + namespace + "'");
            return;
        }
        this.handleElement(recursionContext, rootElement, pathString, true, false, order);
    }

    private Entry getEntry(XLocator path) {
        return this.entries.get(path.stripAttr());
    }

    @Override
    public SchemaModelPathDescriptor getRootPathDescriptor() {
        return this.rootPathDescriptor;
    }

    @Override
    public SchemaModelPathDescriptor findPathDescriptor(XLocator path) {
        return this.getEntry(path);
    }

    @Override
    public SchemaModelPathRelationship findPathRelationshipToContext(XLocator context, XLocator path) {
        XLocator absolutePath;
        if (path.size() == 1 && path.isAttr()) {
            return this.getEntry(context);
        }
        if (path.isAttr()) {
            boolean turtles = true;
            for (XLocatorStep step : path.stripAttr().getSteps()) {
                if (step.getName().equals("..")) continue;
                turtles = false;
                break;
            }
            if (turtles) {
                return this.getEntry(context);
            }
        }
        if (this.checkImmediateAvailability(context, path = path.stripAttr(), absolutePath = path.relativeTo(context))) {
            Entry contextEntry = this.getEntry(context);
            Entry pathEntry = this.getEntry(absolutePath);
            if (contextEntry.minPreOrder <= pathEntry.minPreOrder) {
                return pathEntry;
            }
            return new SchemaModelPathRelationshipImpl(pathEntry, SchemaModelPathAvailability.AVAILABLE_BEFORE);
        }
        XLocator commonRoot = context.commonRootWith(absolutePath);
        int endIndex = context.size();
        int startIndex = commonRoot.size();
        startIndex = !path.isRelative() ? 1 : 1 + endIndex + path.top();
        for (int index = startIndex; index <= endIndex; ++index) {
            Entry subPathEntry = this.getEntry(context.subPath(index));
            if (!subPathEntry.isRepeating()) continue;
            return new SchemaModelPathRelationshipImpl(subPathEntry, SchemaModelPathAvailability.FORWARD_OF_REPEATING);
        }
        return new SchemaModelPathRelationshipImpl(this.getEntry(commonRoot), SchemaModelPathAvailability.FORWARD_OF_NON_REPEATING);
    }

    private boolean checkImmediateAvailability(XLocator context, XLocator path, XLocator absolutePath) {
        int startIndex;
        int top;
        if (!absolutePath.equals(context) && absolutePath.isSubPathOf(context)) {
            return false;
        }
        Entry contextEntry = this.getEntry(context);
        Entry pathEntry = this.getEntry(absolutePath);
        int n = top = path.isRelative() ? -path.top() : context.size();
        if (top == 0) {
            return contextEntry.minPostOrder >= pathEntry.maxPostOrder;
        }
        for (int index = startIndex = 1 + context.size() - top; index <= context.size() && index <= absolutePath.size(); ++index) {
            Entry pathSubPathEntry;
            Entry contextSubPathEntry = this.getEntry(context.subPath(index));
            if (contextSubPathEntry == (pathSubPathEntry = this.getEntry(absolutePath.subPath(index))) && pathSubPathEntry.isRepeating()) {
                return false;
            }
            if (contextSubPathEntry.minPostOrder >= pathSubPathEntry.maxPostOrder) continue;
            return false;
        }
        return true;
    }

    private void handleElement(RecursionContext recursionContext, XSElementDeclaration element, String pathString, boolean mandatory, boolean repeating, int[] order) throws IOException, SAXException {
        int maxPostOrder;
        XSTerm term;
        XSComplexTypeDefinition complexType;
        XSParticle particle;
        boolean simple;
        int maxPreOrder;
        String prefix = "";
        if (recursionContext.mapper != null) {
            prefix = recursionContext.mapper.mapNamespaceToPrefix(element.getNamespace());
            prefix = prefix == null ? "" : prefix + ":";
        }
        pathString = pathString + '/' + prefix + element.getName();
        XLocator path = XLocator.create(pathString);
        int minPreOrder = maxPreOrder = (order[0] = order[0] + 1);
        XSTypeDefinition type = element.getTypeDefinition();
        boolean bl = simple = type.getTypeCategory() == 16;
        if (!simple && (particle = (complexType = (XSComplexTypeDefinition)type).getParticle()) != null && (term = particle.getTerm()) instanceof XSModelGroup) {
            this.handleGroup(recursionContext, (XSModelGroup)term, pathString, path, false, order);
        }
        int minPostOrder = maxPostOrder = (order[1] = order[1] + 1);
        Entry entry = this.getEntry(path);
        if (entry != null) {
            minPreOrder = entry.minPreOrder;
            minPostOrder = entry.minPostOrder;
            mandatory |= entry.mandatory;
            repeating = true;
        }
        entry = new Entry(path, mandatory, repeating, simple, minPreOrder, maxPreOrder, minPostOrder, maxPostOrder);
        this.entries.put(path, entry);
        if (entry.minPreOrder == 1) {
            this.rootPathDescriptor = entry;
        }
    }

    private void handleGroup(RecursionContext recursionContext, XSModelGroup group, String pathString, XLocator path, boolean repeating, int[] order) throws IOException, SAXException {
        XSObjectList particles = group.getParticles();
        for (int i = 0; i < particles.getLength(); ++i) {
            XSObject item = particles.item(i);
            if (!(item instanceof XSParticle)) continue;
            XSParticle subParticle = (XSParticle)item;
            boolean mandatory = subParticle.getMinOccurs() > 0;
            boolean subRepeating = repeating | (subParticle.getMaxOccursUnbounded() || subParticle.getMaxOccurs() > 1);
            XSTerm subTerm = subParticle.getTerm();
            if (subTerm instanceof XSElementDeclaration) {
                this.handleElement(recursionContext, (XSElementDeclaration)subTerm, pathString, mandatory, subRepeating, order);
                continue;
            }
            if (subTerm instanceof XSModelGroup) {
                this.handleGroup(recursionContext, (XSModelGroup)subTerm, pathString, path, subRepeating, order);
                continue;
            }
            if (!(subTerm instanceof XSWildcard)) continue;
            this.handleWildcard(recursionContext, (XSWildcard)subTerm, pathString, path, order);
        }
    }

    private void handleWildcard(RecursionContext recursionContext, XSWildcard wildcard, String pathString, XLocator path, int[] order) throws IOException, SAXException {
        if (recursionContext.mapper == null || recursionContext.path == null) {
            return;
        }
        if (recursionContext.path.size() <= path.size()) {
            return;
        }
        if (wildcard.getConstraintType() == 1) {
            XLocatorStep step = recursionContext.path.getStep(path.size());
            this.processGrammar(recursionContext, recursionContext.mapper.mapPrefixToNamespace(step.getPrefix()), step.getName(), pathString, order);
        }
    }

    public String toString() {
        ArrayList<Entry> list = new ArrayList<Entry>(this.entries.values());
        Collections.sort(list, new Comparator<Entry>(){

            @Override
            public int compare(Entry e1, Entry e2) {
                return e1.minPreOrder - e2.minPreOrder;
            }
        });
        StringBuilder b = new StringBuilder();
        b.append("{" + this.namespace + "}" + this.root + "\n");
        for (Entry entry : list) {
            b.append(entry).append('\n');
        }
        return b.toString();
    }

    private static class SchemaModelPathRelationshipImpl
    implements SchemaModelPathRelationship {
        private final SchemaModelPathDescriptor pathDescriptor;
        private final SchemaModelPathAvailability availability;

        SchemaModelPathRelationshipImpl(SchemaModelPathDescriptor pathDescriptor, SchemaModelPathAvailability availability) {
            this.pathDescriptor = pathDescriptor;
            this.availability = availability;
        }

        @Override
        public SchemaModelPathDescriptor getPathDescriptor() {
            return this.pathDescriptor;
        }

        @Override
        public SchemaModelPathAvailability getAvailability() {
            return this.availability;
        }
    }

    private class Entry
    implements SchemaModelPathRelationship,
    SchemaModelPathDescriptor {
        final XLocator path;
        final boolean mandatory;
        final boolean repeating;
        final boolean simple;
        final int minPreOrder;
        final int maxPreOrder;
        final int minPostOrder;
        final int maxPostOrder;

        Entry(XLocator path, boolean mandatory, boolean repeating, boolean simple, int minPreOrder, int maxPreOrder, int minPostOrder, int maxPostOrder) {
            this.path = path;
            this.mandatory = mandatory;
            this.repeating = repeating;
            this.simple = simple;
            this.minPreOrder = minPreOrder;
            this.maxPreOrder = maxPreOrder;
            this.minPostOrder = minPostOrder;
            this.maxPostOrder = maxPostOrder;
        }

        public String toString() {
            return "[" + this.path + ": " + (this.mandatory ? "mandatory" : "optional") + "/" + (this.repeating ? "repeating" : "unique") + "/" + (this.simple ? "simple" : "complex") + ", " + this.minPreOrder + "/" + this.maxPreOrder + ", " + this.minPostOrder + "/" + this.maxPostOrder + "]";
        }

        @Override
        public SchemaModelPathDescriptor getPathDescriptor() {
            return this;
        }

        @Override
        public SchemaModelPathAvailability getAvailability() {
            return SchemaModelPathAvailability.AVAILABLE_IN;
        }

        @Override
        public XLocator getPath() {
            return this.path;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Override
        public boolean isRepeating() {
            return this.repeating;
        }

        @Override
        public boolean isSimple() {
            return this.simple;
        }

        @Override
        public Set<SchemaModelPathDescriptor> getChildren() {
            if (this.isSimple()) {
                return Collections.emptySet();
            }
            HashSet<Entry> result = new HashSet<Entry>();
            for (Entry entry : XsdSchemaModel.this.entries.values()) {
                if (!this.getPath().isSubPathOf(entry.getPath())) continue;
                result.add(entry);
            }
            return Collections.unmodifiableSet(result);
        }
    }

    private static final class RecursionContext {
        private static final String EXTERNAL_SCHEMA_LOCATION_PROPERTY = "http://apache.org/xml/properties/schema/external-schemaLocation";
        final EntityResolver entityResolver;
        final NamespacePrefixMapper mapper;
        final XLocator path;
        final XMLSchemaLoader loader;

        public RecursionContext(EntityResolver entityResolver, NamespacePrefixMapper mapper, XLocator path) {
            this.entityResolver = entityResolver;
            this.mapper = mapper;
            this.path = path;
            this.loader = new XMLSchemaLoader();
            this.loader.setProperty(EXTERNAL_SCHEMA_LOCATION_PROPERTY, (Object)entityResolver.getExternalSchemaLocations());
            this.loader.setEntityResolver((XMLEntityResolver)new EntityResolverWrapper((org.xml.sax.EntityResolver)entityResolver));
        }
    }
}

