/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java;

import com.gsl.xslt2java.LocationPathUseHint;
import com.gsl.xslt2java.LocationPathUseType;
import com.gsl.xslt2java.XPathToJavaTranslator;
import com.gsl.xslt2java.xpath.AttributeStep;
import com.gsl.xslt2java.xpath.LocationPath;
import com.gsl.xslt2java.xpath.LocationPathStep;
import com.gsl.xslt2java.xpath.SelfNodeStep;
import com.gsl.xslt2java.xpath.XSLTCurrentStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class LocationPathDescriptor {
    private static final String CURRENT = "current()/";
    private final List<LocationPathUseHint> useHints = new ArrayList<LocationPathUseHint>();
    private final LocationPath path;
    private final String propertyName;
    private final LocationPathUseType useType;
    private LocationPathDescriptor predicationPath = null;
    private final List<LocationPathDescriptor> pathsUsedInPredicate = new ArrayList<LocationPathDescriptor>();

    public LocationPathDescriptor(LocationPath path, String propertyName, LocationPathUseType useType) {
        this.path = path;
        this.propertyName = propertyName;
        this.useType = useType;
    }

    public LocationPathDescriptor(String pathString, String propertyName, LocationPathUseType useType) {
        this(XPathToJavaTranslator.parseLocationPath(pathString), propertyName, useType);
    }

    public LocationPath getPath() {
        return this.path;
    }

    public LocationPath getEffectivePath() {
        return this.path.getEffectivePath();
    }

    public String getPathString() {
        return this.path.asPathString();
    }

    public String getEffectivePathString() {
        return this.path.getEffectivePathString();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public LocationPathUseType getUseType() {
        return this.useType;
    }

    public boolean promotesWithCurrent() {
        return this.path.usesCurrent();
    }

    public int hashCode() {
        return this.path.hashCode() ^ this.propertyName.hashCode() ^ this.useType.hashCode();
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && other.getClass() == this.getClass()) {
            LocationPathDescriptor that = (LocationPathDescriptor)other;
            result = this.path.equals(that.path) && this.propertyName.equals(that.propertyName) && this.useType == that.useType && this.pathsUsedInPredicate.equals(that.pathsUsedInPredicate);
        }
        return result;
    }

    public String toString() {
        return "LocationPathDescriptor [path='" + this.path + "', useType=" + (Object)((Object)this.useType) + ", predicationPath='" + this.predicationPath + "']";
    }

    public void addUseHint(LocationPathUseHint hint) {
        this.useHints.add(hint);
    }

    public List<LocationPathUseHint> getUseHints() {
        return this.useHints;
    }

    public LocationPathDescriptor getPredicationPath() {
        return this.predicationPath;
    }

    public boolean isInAPredicate() {
        return this.predicationPath != null;
    }

    public void setPredicationPath(LocationPathDescriptor chainedPath) {
        this.predicationPath = chainedPath;
    }

    public void addPathsUsedInPredicates(Set<LocationPathDescriptor> pathsUsedInPredicates) {
        for (LocationPathDescriptor descriptor : pathsUsedInPredicates) {
            boolean isSimpleAttribute;
            LocationPath predicatePath = descriptor.getPath();
            LocationPathStep firstStep = predicatePath.getFirstStep();
            boolean isDot = predicatePath.stepCount() == 1 && firstStep instanceof SelfNodeStep;
            boolean isRelativeToCurrent = firstStep instanceof XSLTCurrentStep;
            boolean bl = isSimpleAttribute = predicatePath.stepCount() == 1 && firstStep instanceof AttributeStep;
            if (isDot || isRelativeToCurrent || isSimpleAttribute) continue;
            descriptor.setPredicationPath(this);
            this.pathsUsedInPredicate.add(descriptor);
        }
    }

    public List<LocationPathDescriptor> getPathsUsedInPredicate() {
        return this.pathsUsedInPredicate;
    }

    public boolean isComplex() {
        return this.path.isComplex() || this.predicationPath != null && this.predicationPath.isComplex();
    }

    public boolean hasPredicates() {
        return this.path.hasPredicates();
    }
}

