/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java;

import com.gsl.xslt2java.expression.AbstractLocationPathCatalog;
import com.gsl.xslt2java.xpath.LocationPath;
import com.gsl.xslt2java.xpath.XSLTCurrentStep;
import java.util.HashMap;
import java.util.Map;

public class SimpleLocationPathCatalog
extends AbstractLocationPathCatalog {
    private final Map<String, String> locationPathToPropertyName = new HashMap<String, String>();

    @Override
    public String mapPathToPropertyName(LocationPath locationPath) {
        if (locationPath.stepCount() == 1 && locationPath.getFirstStep() instanceof XSLTCurrentStep) {
            return "contextNodeValue";
        }
        String result = this.locationPathToPropertyName.get(locationPath.getEffectivePathString());
        assert (result != null) : locationPath + " is not in the catalog";
        return result;
    }

    @Override
    public String addLocationPath(LocationPath locationPath) {
        String propertyName = this.getPropertyNameOfPath(locationPath);
        String firstCharacter = propertyName.substring(0, 1).toLowerCase();
        propertyName = propertyName.length() > 1 ? firstCharacter + propertyName.substring(1) : firstCharacter;
        String key = locationPath.getEffectivePathString();
        if (!this.locationPathToPropertyName.containsKey(key)) {
            int i = 0;
            while (this.locationPathToPropertyName.containsValue(propertyName + i)) {
                ++i;
            }
            propertyName = propertyName + i;
            this.locationPathToPropertyName.put(key, propertyName);
        } else {
            propertyName = this.locationPathToPropertyName.get(key);
        }
        return propertyName;
    }
}

