/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java;

import com.gsl.xslt2java.SimpleLocationPathCatalog;
import com.gsl.xslt2java.TransformingModifier;
import com.gsl.xslt2java.TranslationContext;
import com.gsl.xslt2java.XPathLexer;
import com.gsl.xslt2java.XPathParser;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionModifier;
import com.gsl.xslt2java.expression.LocationPathCatalog;
import com.gsl.xslt2java.statement.Statement;
import com.gsl.xslt2java.transformer.ExpressionTransformer;
import com.gsl.xslt2java.transformer.Transformation;
import com.gsl.xslt2java.transformer.optimizations.CountMatchPrecedingOpt;
import com.gsl.xslt2java.transformer.optimizations.MatchPrecedingOpt;
import com.gsl.xslt2java.transformer.optimizations.ReWriteLanguageAttribute;
import com.gsl.xslt2java.xpath.LocationPath;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class XPathToJavaTranslator {
    private final TranslationContext translationContext;
    private final boolean performOptimizations;
    private static final ExpressionTransformer XPATH_TO_JAVA_TRANSFORMER = new ExpressionTransformer(XPathToJavaTranslator.class.getResourceAsStream("/XPathToJava.txform"));
    private static final ExpressionTransformer OPTIMIZATION_TRANSFORMER = new ExpressionTransformer(XPathToJavaTranslator.class.getResourceAsStream("/Optimizations.txform"));

    public static TranslationContext makeContext() {
        return new TranslationContext();
    }

    public XPathToJavaTranslator() {
        this(XPathToJavaTranslator.makeContext());
    }

    public XPathToJavaTranslator(boolean performOptimizations) {
        this(XPathToJavaTranslator.makeContext(), performOptimizations);
    }

    public XPathToJavaTranslator(TranslationContext translationContext) {
        this(translationContext, true);
    }

    public XPathToJavaTranslator(TranslationContext translationContext, boolean performOptimiztions) {
        this.translationContext = translationContext;
        this.performOptimizations = performOptimiztions;
    }

    public static LocationPath parseLocationPath(String pathString) {
        XPathParser parser = XPathToJavaTranslator.makeParser(pathString);
        parser.locationPathCatalog = new SimpleLocationPathCatalog();
        try {
            return parser.locationPath();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static XPathParser makeParser(String pathString) {
        XPathLexer lexer = new XPathLexer((CharStream)new ANTLRStringStream(pathString));
        return new XPathParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
    }

    public static Expression translateExpression(String xslt) {
        return new XPathToJavaTranslator().translate(xslt);
    }

    public Expression translate(String xslt) {
        Expression expression = this.parseExpression(xslt);
        TransformingModifier modifier = new TransformingModifier(XPATH_TO_JAVA_TRANSFORMER);
        expression = this.transformExpression(expression, modifier);
        this.transformSupportingStatements(expression, modifier);
        if (this.performOptimizations) {
            modifier = new TransformingModifier(OPTIMIZATION_TRANSFORMER);
            expression = this.transformExpression(expression, modifier);
            this.transformSupportingStatements(expression, modifier);
        }
        return expression;
    }

    public Expression parseExpression(String xslt) {
        String path = xslt.equals("(.)/*") ? "child::*" : xslt;
        XPathParser parser = XPathToJavaTranslator.makeParser(path);
        try {
            return parser.parseExpression(this.translationContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void transformSupportingStatements(Expression expression, ExpressionModifier modifier) {
        block0: for (Statement statement : expression.getSupportingStatements()) {
            for (int i = 0; i < modifier.getMaxPassCount(); ++i) {
                statement.modifyExpressions(modifier);
                if (!modifier.expressionWasModified()) continue block0;
                modifier.reset();
            }
        }
    }

    private Expression transformExpression(Expression expression, ExpressionModifier modifier) {
        LocationPathCatalog lpc = expression.getLocationPathCatalog();
        for (int i = 0; i < modifier.getMaxPassCount(); ++i) {
            expression = expression.modify(modifier);
            if (!modifier.expressionWasModified()) break;
            modifier.reset();
        }
        expression.setLocationPathCatalog(lpc);
        return expression;
    }

    public LocationPath translateLocationPath(String locationPathString) throws Exception {
        XPathParser parser = XPathToJavaTranslator.makeParser(locationPathString);
        parser.locationPathCatalog = new SimpleLocationPathCatalog();
        return parser.locationPath();
    }

    static {
        Transformation[] specialOptimisations = new Transformation[]{new CountMatchPrecedingOpt(), new MatchPrecedingOpt(), new ReWriteLanguageAttribute()};
        OPTIMIZATION_TRANSFORMER.addTransforms(specialOptimisations);
    }
}

