/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression;

import com.gsl.xslt2java.LocationPathDescriptor;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionModifier;
import com.gsl.xslt2java.expression.ExpressionVisitor;
import com.gsl.xslt2java.expression.LocationPathCatalog;
import com.gsl.xslt2java.expression.emitter.JavaEmitter;
import com.gsl.xslt2java.expression.types.ExpressionType;
import com.gsl.xslt2java.statement.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractExpression
implements Expression {
    private List<Statement> supportingStatements = Collections.EMPTY_LIST;
    private LocationPathCatalog locationPathCatalog = null;

    @Override
    public abstract Expression clone();

    @Override
    public List<Statement> getSupportingStatements() {
        return this.supportingStatements;
    }

    public void setSupportingStatements(List<Statement> supportingStatements) {
        this.supportingStatements = supportingStatements;
    }

    @Override
    public ExpressionType type() {
        return ExpressionType.UnknownType;
    }

    @Override
    public Expression modify(ExpressionModifier modifier) {
        this.modifyChildren(modifier);
        return modifier.modify(this);
    }

    @Override
    public abstract void accept(ExpressionVisitor var1);

    public String asBooleanJavaExpression() {
        return JavaEmitter.asBooleanExpression(this);
    }

    public String asComplexBooleanJavaExpression() {
        return JavaEmitter.asComplexBooleanExpression(this);
    }

    @Override
    public String asJavaExpression() {
        return JavaEmitter.asSimpleJava(this);
    }

    protected abstract void modifyChildren(ExpressionModifier var1);

    protected List<Expression> cloneParameters(List<Expression> parameters) {
        ArrayList<Expression> clonedParams = new ArrayList<Expression>();
        Iterator<Expression> i$ = parameters.iterator();
        while (i$.hasNext()) {
            Expression element;
            Expression param = element = i$.next();
            Expression clonedParam = param.clone();
            clonedParams.add(clonedParam);
        }
        return clonedParams;
    }

    @Override
    public String asList(boolean complex) {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    public LocationPathCatalog getLocationPathCatalog() {
        return this.locationPathCatalog;
    }

    @Override
    public void setLocationPathCatalog(LocationPathCatalog locationPathCatalog) {
        this.locationPathCatalog = locationPathCatalog;
    }

    @Override
    public void setPredicate(Expression predicateExpression) {
        throw new UnsupportedOperationException("implement me for " + this.getClass().getName());
    }

    @Override
    public boolean hasComplexPaths() {
        boolean result = false;
        for (LocationPathDescriptor descriptor : this.requiredLocationPathDescriptors()) {
            if (!descriptor.isComplex()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean hasPredicates() {
        boolean result = false;
        for (LocationPathDescriptor descriptor : this.requiredLocationPathDescriptors()) {
            if (!descriptor.hasPredicates()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public Expression getMainExpresssion() {
        return this;
    }
}

