/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression;

import com.gsl.xslt2java.LocationPathDescriptor;
import com.gsl.xslt2java.expression.AbstractExpression;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionModifier;
import com.gsl.xslt2java.expression.ExpressionVisitor;
import com.gsl.xslt2java.expression.LocationPathCatalog;
import com.gsl.xslt2java.expression.types.ExpressionType;
import com.gsl.xslt2java.xpath.LocationPath;
import java.util.HashSet;
import java.util.Set;

public class BooleanCast
extends AbstractExpression {
    private Expression subExpression;

    @Override
    public Expression clone() {
        Expression result = null;
        Expression subExpressionClone = this.subExpression.clone();
        result = subExpressionClone.type() == ExpressionType.BooleanType ? subExpressionClone : new BooleanCast(subExpressionClone);
        return result;
    }

    public static Expression cast(Expression e) {
        if (e.type() == ExpressionType.BooleanType) {
            return e;
        }
        return new BooleanCast(e);
    }

    @Override
    public LocationPathCatalog getLocationPathCatalog() {
        return this.subExpression.getLocationPathCatalog();
    }

    public BooleanCast(Expression subExpression) {
        this.subExpression = subExpression;
    }

    public String toString() {
        return "BooleanCast(" + this.subExpression + ")";
    }

    @Override
    public Set<LocationPathDescriptor> requiredLocationPathDescriptors() {
        HashSet<LocationPathDescriptor> descriptors = new HashSet<LocationPathDescriptor>();
        descriptors.addAll(this.subExpression.requiredLocationPathDescriptors());
        return descriptors;
    }

    @Override
    public Set<LocationPath> requiredLocationPaths() {
        HashSet<LocationPath> paths = new HashSet<LocationPath>();
        paths.addAll(this.subExpression.requiredLocationPaths());
        return paths;
    }

    @Override
    public ExpressionType type() {
        return ExpressionType.BooleanType;
    }

    @Override
    protected void modifyChildren(ExpressionModifier modifier) {
        this.subExpression = this.subExpression.modify(modifier);
    }

    @Override
    public void accept(ExpressionVisitor v) {
        v.atBooleanCast(this);
    }

    public Expression getSubExpression() {
        return this.subExpression;
    }
}

