/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression;

import com.gsl.xslt2java.LocationPathDescriptor;
import com.gsl.xslt2java.LocationPathUseType;
import com.gsl.xslt2java.expression.AbstractExpression;
import com.gsl.xslt2java.expression.Call;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionModifier;
import com.gsl.xslt2java.expression.ExpressionVisitor;
import com.gsl.xslt2java.expression.LocationPathCatalog;
import com.gsl.xslt2java.expression.LocationPathExpression;
import com.gsl.xslt2java.expression.types.ExpressionType;
import com.gsl.xslt2java.statement.Statement;
import com.gsl.xslt2java.xpath.LocationPath;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CountExpression
extends AbstractExpression
implements Call {
    private final Expression location;

    public CountExpression(Expression location) {
        this.location = location;
    }

    @Override
    public CountExpression clone() {
        return new CountExpression(this.location.clone());
    }

    public String toString() {
        return "Count(" + this.location + ")";
    }

    @Override
    public Set<LocationPathDescriptor> requiredLocationPathDescriptors() {
        HashSet<LocationPathDescriptor> descriptors = new HashSet<LocationPathDescriptor>();
        if (this.location instanceof LocationPathExpression) {
            LocationPathExpression locationPathExpression = (LocationPathExpression)this.location;
            descriptors = new HashSet();
            LocationPath path = locationPathExpression.getPath();
            String propertyName = this.getLocationPathCatalog().addLocationPath(path);
            Expression predicate = locationPathExpression.getPath().getLastStep().getPredicate();
            if (predicate != null) {
                descriptors.add(new LocationPathDescriptor(path, propertyName, LocationPathUseType.Value));
                descriptors.addAll(this.location.requiredLocationPathDescriptors());
            } else {
                descriptors.add(new LocationPathDescriptor(path, propertyName, LocationPathUseType.Count));
            }
        } else {
            descriptors.addAll(this.location.requiredLocationPathDescriptors());
        }
        return descriptors;
    }

    @Override
    public Set<LocationPath> requiredLocationPaths() {
        HashSet<LocationPath> paths = new HashSet<LocationPath>();
        paths.addAll(this.location.requiredLocationPaths());
        return paths;
    }

    @Override
    public LocationPathCatalog getLocationPathCatalog() {
        return this.location.getLocationPathCatalog();
    }

    @Override
    public void setScope(String scope) {
    }

    @Override
    public List<Statement> getSupportingStatements() {
        return this.location.getSupportingStatements();
    }

    @Override
    public ExpressionType type() {
        return ExpressionType.IntegerType;
    }

    @Override
    protected void modifyChildren(ExpressionModifier modifier) {
    }

    @Override
    public void accept(ExpressionVisitor v) {
        v.atCountExpression(this);
    }

    public Expression getLocation() {
        return this.location;
    }
}

