/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression;

import com.gsl.xslt2java.LocationPathDescriptor;
import com.gsl.xslt2java.QName;
import com.gsl.xslt2java.expression.AbstractExpression;
import com.gsl.xslt2java.expression.Atom;
import com.gsl.xslt2java.expression.Call;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionModifier;
import com.gsl.xslt2java.expression.ExpressionVisitor;
import com.gsl.xslt2java.expression.types.ExpressionType;
import com.gsl.xslt2java.statement.Statement;
import com.gsl.xslt2java.xpath.LocationPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FunctionCall
extends AbstractExpression
implements Atom,
Call {
    private String scope;
    private final String name;
    private List<Expression> parameters;
    private ExpressionType returnType = ExpressionType.UnknownType;

    public FunctionCall(String scope, String name, List<Expression> parameters) {
        this.scope = scope;
        this.name = name;
        this.parameters = parameters;
    }

    public FunctionCall(QName name, List<Expression> parameters) {
        this(name.getPrefix(), name.getLocalName(), parameters);
    }

    public FunctionCall(String name, List<Expression> parameters) {
        this(null, name, parameters);
    }

    @Override
    public ExpressionType type() {
        return this.returnType;
    }

    public FunctionCall(String name) {
        this(null, name, Collections.EMPTY_LIST);
    }

    @Override
    public List<Statement> getSupportingStatements() {
        ArrayList<Statement> supportingStatements = new ArrayList<Statement>();
        for (Expression e : this.parameters) {
            supportingStatements.addAll(e.getSupportingStatements());
        }
        return supportingStatements;
    }

    @Override
    public Expression clone() {
        FunctionCall clone = new FunctionCall(this.scope, this.name, this.cloneParameters(this.getParameters()));
        clone.setReturnType(this.getReturnType());
        return clone;
    }

    @Override
    protected void modifyChildren(ExpressionModifier modifier) {
        ArrayList<Expression> modifiedParams = new ArrayList<Expression>();
        Iterator<Expression> i$ = this.parameters.iterator();
        while (i$.hasNext()) {
            Expression element;
            Expression param = element = i$.next();
            Expression modifiedParam = param.modify(modifier);
            modifiedParams.add(modifiedParam);
        }
        this.parameters = modifiedParams;
    }

    @Override
    public Set<LocationPathDescriptor> requiredLocationPathDescriptors() {
        HashSet<LocationPathDescriptor> requiredXPaths = new HashSet<LocationPathDescriptor>();
        for (Expression param : this.parameters) {
            requiredXPaths.addAll(param.requiredLocationPathDescriptors());
        }
        return requiredXPaths;
    }

    @Override
    public Set<LocationPath> requiredLocationPaths() {
        HashSet<LocationPath> requiredXPaths = new HashSet<LocationPath>();
        for (Expression param : this.parameters) {
            requiredXPaths.addAll(param.requiredLocationPaths());
        }
        return requiredXPaths;
    }

    @Override
    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getName() {
        return this.name;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public String getScope() {
        return this.scope;
    }

    @Override
    public void accept(ExpressionVisitor v) {
        v.atFunctionCall(this);
    }

    public ExpressionType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ExpressionType returnType) {
        this.returnType = returnType;
    }

    public String toString() {
        String result = "FunctionCall ";
        if (this.scope != null && !this.scope.equals("")) {
            result = result + this.scope + ".";
        }
        result = result + this.name + "(";
        boolean first = true;
        for (Expression param : this.getParameters()) {
            if (!first) {
                result = result + ", ";
            }
            result = result + param.toString();
            first = false;
        }
        result = result + ")";
        return result;
    }
}

