/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression;

import com.gsl.xslt2java.LocationPathDescriptor;
import com.gsl.xslt2java.expression.AbstractExpression;
import com.gsl.xslt2java.expression.Atom;
import com.gsl.xslt2java.expression.ExpressionModifier;
import com.gsl.xslt2java.expression.ExpressionVisitor;
import com.gsl.xslt2java.expression.types.ExpressionType;
import com.gsl.xslt2java.xpath.LocationPath;
import java.util.Collections;
import java.util.Set;

public class IntegerLiteral
extends AbstractExpression
implements Atom {
    private final String value;

    public IntegerLiteral(String val) {
        this.value = val;
    }

    public IntegerLiteral(long val) {
        this.value = "" + val;
    }

    @Override
    public void accept(ExpressionVisitor v) {
        v.atIntegerLiteral(this);
    }

    @Override
    public IntegerLiteral clone() {
        return new IntegerLiteral(this.value);
    }

    @Override
    protected void modifyChildren(ExpressionModifier modifier) {
    }

    @Override
    public Set<LocationPathDescriptor> requiredLocationPathDescriptors() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<LocationPath> requiredLocationPaths() {
        return Collections.EMPTY_SET;
    }

    @Override
    public ExpressionType type() {
        return ExpressionType.IntegerType;
    }

    public long getNumericValue() {
        return Long.parseLong(this.value);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "IntegerLiteral " + this.value;
    }
}

