/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression;

import com.gsl.xslt2java.LocationPathDescriptor;
import com.gsl.xslt2java.LocationPathUseType;
import com.gsl.xslt2java.expression.AbstractExpression;
import com.gsl.xslt2java.expression.Atom;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionModifier;
import com.gsl.xslt2java.expression.ExpressionVisitor;
import com.gsl.xslt2java.expression.IntegerLiteral;
import com.gsl.xslt2java.expression.LocationPathCatalog;
import com.gsl.xslt2java.expression.emitter.JavaEmitter;
import com.gsl.xslt2java.expression.types.ExpressionType;
import com.gsl.xslt2java.statement.Statement;
import com.gsl.xslt2java.xpath.LocationPath;
import com.gsl.xslt2java.xpath.LocationPathStep;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LocationPathExpression
extends AbstractExpression
implements Atom {
    private final LocationPath path;

    public LocationPath getPath() {
        return this.path;
    }

    public LocationPathExpression(LocationPathStep firstStep, LocationPathCatalog lpc) {
        this(new LocationPath(firstStep), lpc);
    }

    public LocationPathExpression(LocationPath path, LocationPathCatalog lpc) {
        this.path = path;
        this.setLocationPathCatalog(lpc);
        lpc.addLocationPath(path);
    }

    @Override
    public Expression clone() {
        return this;
    }

    @Override
    public List<Statement> getSupportingStatements() {
        return this.path.getSupportingStatements();
    }

    @Override
    public void setPredicate(Expression predicateExpression) {
        this.path.getLastStep().setPredicate(predicateExpression);
    }

    @Override
    public String asList(boolean complex) {
        LocationPathStep lastStep = this.path.getLastStep();
        if (complex) {
            return JavaEmitter.asComplexJava(this);
        }
        String getter = this.convertNameToGetter(this.getLocationPathCatalog().mapPathToPropertyName(this.path));
        Expression predicate = lastStep.getPredicate();
        if (predicate != null) {
            if (predicate instanceof IntegerLiteral) {
                IntegerLiteral numericPredicate = (IntegerLiteral)predicate;
                getter = getter + "(" + (numericPredicate.getNumericValue() - 1L) + ")";
            } else {
                getter = getter + "(" + this.path.getTrailingPredicateIdentifier() + ")";
            }
        } else {
            getter = getter + "()";
        }
        return getter;
    }

    private String convertNameToGetter(String elementName) {
        String firstCharacter = elementName.substring(0, 1).toUpperCase();
        if ((elementName = firstCharacter + elementName.substring(1)).equals("Class")) {
            elementName = "Clazz";
        }
        return "get" + elementName;
    }

    @Override
    public Set<LocationPathDescriptor> requiredLocationPathDescriptors() {
        HashSet<LocationPathDescriptor> requiredXPaths = new HashSet<LocationPathDescriptor>();
        String propertyName = this.getLocationPathCatalog().addLocationPath(this.getPath());
        LocationPathDescriptor locationPathDescriptor = new LocationPathDescriptor(this.path, propertyName, LocationPathUseType.Value);
        Expression predicate = this.path.getLastStep().getPredicate();
        if (predicate != null) {
            Set<LocationPathDescriptor> requiredLocationPathDescriptors = predicate.requiredLocationPathDescriptors();
            locationPathDescriptor.addPathsUsedInPredicates(requiredLocationPathDescriptors);
            requiredXPaths.addAll(requiredLocationPathDescriptors);
        }
        requiredXPaths.add(locationPathDescriptor);
        return requiredXPaths;
    }

    @Override
    public Set<LocationPath> requiredLocationPaths() {
        HashSet<LocationPath> paths = new HashSet<LocationPath>();
        paths.add(this.getPath());
        Expression predicate = this.path.getLastStep().getPredicate();
        if (predicate != null) {
            for (LocationPath path : predicate.requiredLocationPaths()) {
                paths.add(this.getPath().resolve(path));
            }
        }
        return Collections.unmodifiableSet(paths);
    }

    public String getFullPathName() {
        return this.path.asPathString();
    }

    public boolean isComplex() {
        return this.path.isComplex();
    }

    @Override
    protected void modifyChildren(ExpressionModifier modifier) {
    }

    @Override
    public void accept(ExpressionVisitor v) {
        v.atLocationPathExpression(this);
    }

    public String toString() {
        return this.path.toString();
    }

    @Override
    public ExpressionType type() {
        return ExpressionType.NodeSet;
    }
}

