/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression;

import com.gsl.xslt2java.LocationPathDescriptor;
import com.gsl.xslt2java.LocationPathHintType;
import com.gsl.xslt2java.LocationPathUseHint;
import com.gsl.xslt2java.expression.AbstractExpression;
import com.gsl.xslt2java.expression.Atom;
import com.gsl.xslt2java.expression.Call;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionModifier;
import com.gsl.xslt2java.expression.ExpressionVisitor;
import com.gsl.xslt2java.expression.LocationPathExpression;
import com.gsl.xslt2java.expression.StringLiteral;
import com.gsl.xslt2java.expression.TextExpression;
import com.gsl.xslt2java.expression.types.ExpressionType;
import com.gsl.xslt2java.xpath.LocationPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MethodCall
extends AbstractExpression
implements Atom,
Call {
    private Expression object;
    private final String methodName;
    private List<Expression> parameters;
    private String scope = null;
    private ExpressionType returnType = ExpressionType.UnknownType;

    public MethodCall(Expression object, String methodName, List<Expression> parameters) {
        this.object = object;
        this.methodName = methodName;
        this.parameters = parameters;
    }

    public MethodCall(Expression object, String methodName) {
        this.object = object;
        this.methodName = methodName;
        this.parameters = Collections.EMPTY_LIST;
    }

    @Override
    public ExpressionType type() {
        return this.returnType;
    }

    @Override
    public Expression clone() {
        MethodCall clone = new MethodCall(this.object.clone(), this.methodName, this.cloneParameters(this.getParameters()));
        clone.setScope(this.scope);
        clone.setReturnType(this.getReturnType());
        return clone;
    }

    @Override
    protected void modifyChildren(ExpressionModifier modifier) {
        this.object = this.object.modify(modifier);
        ArrayList<Expression> modifiedParams = new ArrayList<Expression>();
        Iterator<Expression> i$ = this.parameters.iterator();
        while (i$.hasNext()) {
            Expression element;
            Expression param = element = i$.next();
            Expression modifiedParam = modifier.modify(param);
            modifiedParams.add(modifiedParam);
        }
        this.parameters = modifiedParams;
    }

    @Override
    public Set<LocationPathDescriptor> requiredLocationPathDescriptors() {
        HashSet<LocationPathDescriptor> requiredXPaths = new HashSet<LocationPathDescriptor>();
        Set<LocationPathDescriptor> objectLocationPathDescriptors = this.object.requiredLocationPathDescriptors();
        requiredXPaths.addAll(objectLocationPathDescriptors);
        for (Expression param : this.parameters) {
            requiredXPaths.addAll(param.requiredLocationPathDescriptors());
        }
        this.setHintForStartsWith(objectLocationPathDescriptors);
        return requiredXPaths;
    }

    @Override
    public Set<LocationPath> requiredLocationPaths() {
        HashSet<LocationPath> requiredXPaths = new HashSet<LocationPath>();
        requiredXPaths.addAll(this.object.requiredLocationPaths());
        for (Expression param : this.parameters) {
            requiredXPaths.addAll(param.requiredLocationPaths());
        }
        return requiredXPaths;
    }

    private void setHintForStartsWith(Set<LocationPathDescriptor> objectLocationPathDescriptors) {
        if (this.methodName.equals("startsWith") && (this.object instanceof LocationPathExpression || this.object instanceof TextExpression) && this.parameters.size() == 1 && this.parameters.get(0) instanceof StringLiteral) {
            StringLiteral param = (StringLiteral)this.parameters.get(0);
            LocationPathUseHint hint = new LocationPathUseHint(LocationPathHintType.MaxLengthRequired, param.getValue().length());
            for (LocationPathDescriptor descriptor : objectLocationPathDescriptors) {
                descriptor.addUseHint(hint);
            }
        }
    }

    @Override
    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Expression getObject() {
        return this.object;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public String getScope() {
        return this.scope;
    }

    @Override
    public void accept(ExpressionVisitor v) {
        v.atMethodCall(this);
    }

    public ExpressionType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ExpressionType returnType) {
        this.returnType = returnType;
    }

    public String toString() {
        String result = "MethodCall " + this.object + "." + this.methodName + "(";
        boolean first = true;
        for (Expression param : this.getParameters()) {
            if (!first) {
                result = result + ", ";
            }
            result = result + param.toString();
            first = false;
        }
        result = result + ")";
        return result;
    }
}

