/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression;

import com.gsl.xslt2java.LocationPathDescriptor;
import com.gsl.xslt2java.expression.AbstractExpression;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionModifier;
import com.gsl.xslt2java.expression.ExpressionVisitor;
import com.gsl.xslt2java.expression.types.ExpressionType;
import com.gsl.xslt2java.statement.Statement;
import com.gsl.xslt2java.xpath.LocationPath;
import java.util.List;
import java.util.Set;

public class UnaryExpression
extends AbstractExpression {
    public static final String NOT = "!";
    public static final String MINUS = "minus";
    private final String op;
    private Expression rhs;

    public UnaryExpression(String op, Expression rhs) {
        assert (op.equals(NOT) || op.equals(MINUS)) : "Only unary operators supported are '!' and '-'";
        this.op = op;
        this.rhs = rhs;
    }

    @Override
    public Expression clone() {
        return new UnaryExpression(this.op, this.rhs.clone());
    }

    @Override
    public Set<LocationPathDescriptor> requiredLocationPathDescriptors() {
        return this.rhs.requiredLocationPathDescriptors();
    }

    @Override
    public Set<LocationPath> requiredLocationPaths() {
        return this.rhs.requiredLocationPaths();
    }

    @Override
    public List<Statement> getSupportingStatements() {
        return this.rhs.getSupportingStatements();
    }

    public Expression getRhs() {
        return this.rhs;
    }

    @Override
    protected void modifyChildren(ExpressionModifier modifier) {
        this.rhs = this.rhs.modify(modifier);
    }

    @Override
    public void accept(ExpressionVisitor v) {
        v.atUnaryExpression(this);
    }

    public String getOp() {
        return this.op;
    }

    public String toString() {
        return "UnaryExpression (" + this.getOp() + ", " + this.rhs + ")";
    }

    @Override
    public ExpressionType type() {
        if (this.op.equals(NOT)) {
            return ExpressionType.BooleanType;
        }
        if (this.op.equals(MINUS)) {
            return ExpressionType.NumberType;
        }
        return ExpressionType.UnknownType;
    }
}

