/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression.binary;

import com.gsl.xslt2java.expression.AbstractExpression;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionVisitor;
import com.gsl.xslt2java.expression.IntegerLiteral;
import com.gsl.xslt2java.expression.binary.BinaryExpression;
import com.gsl.xslt2java.expression.types.ExpressionType;

public final class AdditiveExpression
extends BinaryExpression {
    public static final String SUBTRACT = "subtract";
    public static final String ADD = "add";

    private AdditiveExpression(String op, Expression lhs, Expression rhs) {
        super(op, lhs, rhs);
        assert (op.equals(ADD) || op.equals(SUBTRACT)) : "Cannot create an additive expression with op '" + op + "'";
    }

    @Override
    public Expression clone() {
        return AdditiveExpression.optimizeAdditiveExpression(this.getOperator(), this.getLhs().clone(), this.getRhs().clone());
    }

    @Override
    public ExpressionType type() {
        return ExpressionType.NumberType;
    }

    public static Expression optimizeAdditiveExpression(String op, Expression lhs, Expression rhs) {
        assert (op.equals(ADD) || op.equals(SUBTRACT)) : "Cannot create an additive expression with op '" + op + "'";
        AbstractExpression result = null;
        if (lhs instanceof IntegerLiteral && rhs instanceof IntegerLiteral) {
            IntegerLiteral lhsLiteral = (IntegerLiteral)lhs;
            IntegerLiteral rhsLiteral = (IntegerLiteral)rhs;
            result = op.equals(SUBTRACT) ? new IntegerLiteral(lhsLiteral.getNumericValue() - rhsLiteral.getNumericValue()) : new IntegerLiteral(lhsLiteral.getNumericValue() + rhsLiteral.getNumericValue());
        } else {
            result = new AdditiveExpression(op, lhs, rhs);
        }
        return result;
    }

    @Override
    public void accept(ExpressionVisitor v) {
        v.atAdditiveExpression(this);
    }
}

