/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression.binary;

import com.gsl.xslt2java.LocationPathDescriptor;
import com.gsl.xslt2java.expression.AbstractExpression;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionModifier;
import com.gsl.xslt2java.statement.Statement;
import com.gsl.xslt2java.xpath.LocationPath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class BinaryExpression
extends AbstractExpression {
    private final String operator;
    private Expression lhs;
    private Expression rhs;

    public BinaryExpression(String operator, Expression lhs, Expression rhs) {
        assert (operator != null);
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public Expression getLhs() {
        return this.lhs;
    }

    public String getOperator() {
        return this.operator;
    }

    public Expression getRhs() {
        return this.rhs;
    }

    @Override
    public Set<LocationPathDescriptor> requiredLocationPathDescriptors() {
        HashSet<LocationPathDescriptor> descriptors = new HashSet<LocationPathDescriptor>();
        descriptors.addAll(this.lhs.requiredLocationPathDescriptors());
        descriptors.addAll(this.rhs.requiredLocationPathDescriptors());
        return descriptors;
    }

    @Override
    public Set<LocationPath> requiredLocationPaths() {
        HashSet<LocationPath> paths = new HashSet<LocationPath>();
        paths.addAll(this.lhs.requiredLocationPaths());
        paths.addAll(this.rhs.requiredLocationPaths());
        return paths;
    }

    @Override
    public List<Statement> getSupportingStatements() {
        ArrayList<Statement> supportingStatements = new ArrayList<Statement>();
        supportingStatements.addAll(this.lhs.getSupportingStatements());
        supportingStatements.addAll(this.rhs.getSupportingStatements());
        return supportingStatements;
    }

    @Override
    protected void modifyChildren(ExpressionModifier modifier) {
        this.lhs = this.lhs.modify(modifier);
        this.rhs = this.rhs.modify(modifier);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.operator + ", " + this.lhs + ", " + this.rhs + ")";
    }
}

