/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression.binary;

import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionVisitor;
import com.gsl.xslt2java.expression.binary.BinaryExpression;
import com.gsl.xslt2java.expression.types.ExpressionType;

public final class MultiplicativeExpression
extends BinaryExpression {
    public static final String DIVIDE = "divide";
    public static final String MULTIPLY = "multiply";
    public static final String MOD = "mod";

    public MultiplicativeExpression(String op, Expression lhs, Expression rhs) {
        super(op, lhs, rhs);
        assert (op != null);
        assert (op.equals(MOD) || op.equals(MULTIPLY) || op.equals(DIVIDE)) : "Cannot create an multiplicative expression with op '" + op + "'";
        assert (lhs != null);
        assert (rhs != null);
    }

    @Override
    public MultiplicativeExpression clone() {
        return new MultiplicativeExpression(this.getOperator(), this.getLhs().clone(), this.getRhs().clone());
    }

    @Override
    public void accept(ExpressionVisitor v) {
        v.atMultiplicativeExpression(this);
    }

    @Override
    public ExpressionType type() {
        return ExpressionType.NumberType;
    }
}

