/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression.emitter;

import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionVisitor;
import com.gsl.xslt2java.expression.emitter.JavaEmitter;
import com.gsl.xslt2java.xpath.LocationPath;

public abstract class AbstractStringEmitter
implements ExpressionVisitor {
    private final StringBuilder stringBuilder = new StringBuilder();
    boolean complex = false;

    public String getString() {
        return this.stringBuilder.toString();
    }

    protected void emit(String string) {
        this.stringBuilder.append(string);
    }

    protected String getLastElementOfPath(LocationPath path) {
        return AbstractStringEmitter.getLastElementOfPath(path.toString());
    }

    public void setComplex(boolean complex) {
        this.complex = complex;
    }

    public boolean isComplex() {
        return this.complex;
    }

    private static String getLastElementOfPath(String pathString) {
        int sq;
        int at;
        int lastSlash = pathString.lastIndexOf(47);
        String elementName = lastSlash >= 0 ? pathString.substring(lastSlash + 1) : pathString;
        int colon = elementName.lastIndexOf(58);
        if (colon >= 0) {
            elementName = elementName.substring(colon + 1);
        }
        if ((at = elementName.indexOf(64)) >= 0) {
            elementName = elementName.substring(at + 1);
        }
        if ((sq = elementName.indexOf(91)) >= 0) {
            elementName = elementName.substring(0, sq);
        }
        return elementName;
    }

    public String asJava(Expression expression) {
        if (this.isComplex()) {
            return JavaEmitter.asComplexJava(expression);
        }
        return JavaEmitter.asSimpleJava(expression);
    }

    protected static String convertNameToGetter(String elementName) {
        String firstCharacter = elementName.substring(0, 1).toUpperCase();
        if ((elementName = firstCharacter + elementName.substring(1)).equals("Class")) {
            elementName = "Clazz";
        }
        return "get" + elementName;
    }
}

