/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression.emitter;

import com.gsl.xslt2java.expression.Atom;
import com.gsl.xslt2java.expression.BooleanCast;
import com.gsl.xslt2java.expression.BooleanLiteral;
import com.gsl.xslt2java.expression.ContextNodeValue;
import com.gsl.xslt2java.expression.CountExpression;
import com.gsl.xslt2java.expression.Current;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.FunctionCall;
import com.gsl.xslt2java.expression.IfExpression;
import com.gsl.xslt2java.expression.IntegerCast;
import com.gsl.xslt2java.expression.IntegerLiteral;
import com.gsl.xslt2java.expression.LocationPathCatalog;
import com.gsl.xslt2java.expression.LocationPathExpression;
import com.gsl.xslt2java.expression.MethodCall;
import com.gsl.xslt2java.expression.NumberCast;
import com.gsl.xslt2java.expression.NumberLiteral;
import com.gsl.xslt2java.expression.ParenthesizedExpression;
import com.gsl.xslt2java.expression.Position;
import com.gsl.xslt2java.expression.StringCast;
import com.gsl.xslt2java.expression.StringLiteral;
import com.gsl.xslt2java.expression.SumExpression;
import com.gsl.xslt2java.expression.TextExpression;
import com.gsl.xslt2java.expression.UnaryExpression;
import com.gsl.xslt2java.expression.Variable;
import com.gsl.xslt2java.expression.VariableExpression;
import com.gsl.xslt2java.expression.binary.AdditiveExpression;
import com.gsl.xslt2java.expression.binary.BooleanBinaryExpression;
import com.gsl.xslt2java.expression.binary.ComparisonExpression;
import com.gsl.xslt2java.expression.binary.ConcatExpression;
import com.gsl.xslt2java.expression.binary.EqualsExpression;
import com.gsl.xslt2java.expression.binary.MultiplicativeExpression;
import com.gsl.xslt2java.expression.binary.NotEqualsExpression;
import com.gsl.xslt2java.expression.binary.UnionExpression;
import com.gsl.xslt2java.expression.emitter.AbstractStringEmitter;
import com.gsl.xslt2java.expression.emitter.NumberEmitter;
import com.gsl.xslt2java.expression.special.CountMatchPreceding;
import com.gsl.xslt2java.expression.types.ExpressionType;
import com.gsl.xslt2java.transformer.BindingReference;
import com.gsl.xslt2java.xpath.AttributeStep;
import com.gsl.xslt2java.xpath.Axis;
import com.gsl.xslt2java.xpath.ChildElementsStep;
import com.gsl.xslt2java.xpath.ElementStep;
import com.gsl.xslt2java.xpath.LocationPath;
import com.gsl.xslt2java.xpath.LocationPathStep;
import com.gsl.xslt2java.xpath.ParentElementStep;
import com.gsl.xslt2java.xpath.RootStep;
import com.gsl.xslt2java.xpath.SelfNodeStep;
import com.gsl.xslt2java.xpath.TextNodeTest;
import com.gsl.xslt2java.xpath.XSLTCurrentStep;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class JavaEmitter
extends AbstractStringEmitter {
    protected JavaEmitter() {
    }

    public static String asSimpleJava(Expression expression) {
        JavaEmitter v = new JavaEmitter();
        expression.accept(v);
        return v.getString();
    }

    public static String asComplexJava(Expression expression) {
        JavaEmitter v = new JavaEmitter();
        v.setComplex(true);
        expression.accept(v);
        return v.getString();
    }

    public static String asComplexBooleanExpression(Expression expression) {
        JavaEmitter v = new JavaEmitter();
        v.setComplex(true);
        if (expression.type() != ExpressionType.BooleanType) {
            expression = new BooleanCast(expression);
        }
        expression.accept(v);
        return v.getString();
    }

    public static String asBooleanExpression(Expression expression) {
        JavaEmitter v = new JavaEmitter();
        if (expression.type() != ExpressionType.BooleanType) {
            expression = new BooleanCast(expression);
        }
        expression.accept(v);
        return v.getString();
    }

    @Override
    public void atAdditiveExpression(AdditiveExpression expression) {
        Expression lhs = expression.getLhs();
        Expression rhs = expression.getRhs();
        HashMap<String, String> operatorTable = new HashMap<String, String>();
        operatorTable.put("add", "+");
        operatorTable.put("subtract", "-");
        if (lhs instanceof IntegerLiteral && rhs instanceof IntegerLiteral) {
            if (expression.getOperator().equals("add")) {
                long val = ((IntegerLiteral)lhs).getNumericValue() + ((IntegerLiteral)rhs).getNumericValue();
                this.emit("" + val);
            } else if (expression.getOperator().equals("subtract")) {
                long val = ((IntegerLiteral)lhs).getNumericValue() - ((IntegerLiteral)rhs).getNumericValue();
                this.emit("" + val);
            }
        } else if (lhs.type() == ExpressionType.IntegerType && rhs.type() == ExpressionType.IntegerType) {
            expression.getLhs().accept(this);
            this.emit(" " + (String)operatorTable.get(expression.getOperator()) + " ");
            expression.getRhs().accept(this);
        } else {
            this.emit(expression.getOperator().toUpperCase() + ".instance().op(");
            expression.getLhs().accept(this);
            this.emit(", ");
            expression.getRhs().accept(this);
            this.emit(")");
        }
    }

    @Override
    public void atMultiplicativeExpression(MultiplicativeExpression expression) {
        Expression lhs = expression.getLhs();
        Expression rhs = expression.getRhs();
        if (lhs instanceof IntegerLiteral && rhs instanceof IntegerLiteral && expression.getOperator().equals("multiply")) {
            long val = ((IntegerLiteral)lhs).getNumericValue() * ((IntegerLiteral)rhs).getNumericValue();
            this.emit("" + val);
        } else {
            this.emit(expression.getOperator().toUpperCase() + ".instance().op(");
            expression.getLhs().accept(this);
            this.emit(", ");
            expression.getRhs().accept(this);
            this.emit(")");
        }
    }

    @Override
    public void atBooleanCast(BooleanCast cast) {
        Expression subExpression = cast.getSubExpression();
        if (subExpression.getMainExpresssion() instanceof ContextNodeValue) {
            this.emit("true");
        } else if (subExpression.type() == ExpressionType.NodeSet) {
            this.emit("!");
            subExpression.accept(this);
            this.emit(".isEmpty()");
        } else if (subExpression.type() != ExpressionType.BooleanType) {
            this.emit("ValueUtil.asBoolean(");
            subExpression.accept(this);
            this.emit(")");
        } else {
            subExpression.accept(this);
        }
    }

    @Override
    public void atBooleanLiteral(BooleanLiteral literal) {
        this.emit(literal.getValue());
    }

    @Override
    public void atCountExpression(CountExpression expression) {
        if (expression.getLocation() instanceof ContextNodeValue) {
            this.emit("1");
        } else if (expression.getLocation() instanceof LocationPathExpression) {
            LocationPathExpression lpe = (LocationPathExpression)expression.getLocation();
            if (lpe.getPath().getLastStep().getPredicate() == null && !this.isComplex()) {
                String getter = JavaEmitter.convertNameToGetter(expression.getLocationPathCatalog().mapPathToPropertyName(lpe.getPath()));
                this.emit(getter + "Count()");
            } else {
                this.emit(expression.getLocation().asList(this.isComplex()) + ".size()");
            }
        } else {
            this.emit(expression.getLocation().asList(this.isComplex()) + ".size()");
        }
    }

    @Override
    public void atSumExpression(SumExpression expression) {
        if (expression.getLocation() instanceof LocationPathExpression) {
            LocationPathExpression lpe = (LocationPathExpression)expression.getLocation();
            if (lpe.getPath().getLastStep().getPredicate() == null && !this.isComplex()) {
                String getter = JavaEmitter.convertNameToGetter(expression.getLocationPathCatalog().mapPathToPropertyName(lpe.getPath()));
                this.emit(getter + "Sum()");
            } else {
                this.emit("NumberUtil.sum(" + expression.getLocation().asList(this.isComplex()) + ")");
            }
        } else {
            this.emit("NumberUtil.sum(" + expression.getLocation().asList(this.isComplex()) + ")");
        }
    }

    @Override
    public void atCurrent(Current current) {
        this.emit("getContextNodeValue()");
    }

    @Override
    public void atFunctionCall(FunctionCall call) {
        String scope = call.getScope();
        String name = call.getName();
        if (!scope.equals("")) {
            this.emit(scope + "." + name + "(");
        } else {
            this.emit(name + "(");
        }
        boolean first = true;
        List<Expression> parameters = call.getParameters();
        for (Expression param : parameters) {
            if (!first) {
                this.emit(", ");
            }
            first = false;
            param.accept(this);
        }
        this.emit(")");
    }

    @Override
    public void atIfExpression(IfExpression expression) {
        BooleanCast.cast(expression.getCondition()).accept(this);
        this.emit(" ? ");
        BooleanCast.cast(expression.getThenExpression()).accept(this);
        this.emit(" : ");
        BooleanCast.cast(expression.getElseExpression()).accept(this);
    }

    @Override
    public void atLocationPathExpression(LocationPathExpression expression) {
        LocationPathCatalog lpCat = expression.getLocationPathCatalog();
        LocationPath path = expression.getPath();
        this.emitLocationPath(lpCat, path);
    }

    private void emitLocationPath(LocationPathCatalog lpCat, LocationPath path) {
        if (this.isComplex()) {
            this.emit("contextNode");
            for (LocationPathStep step : path.getSteps()) {
                this.emitStep(step);
            }
            LocationPathStep lastStep = path.getLastStep();
            Expression predicate = lastStep.getPredicate();
            if (predicate != null) {
                this.emit(".applyPredicate");
                this.emitPredicate(path, predicate);
            }
        } else {
            this.emit(JavaEmitter.convertNameToGetter(lpCat.mapPathToPropertyName(path)));
            LocationPathStep lastStep = path.getLastStep();
            Expression predicate = lastStep.getPredicate();
            if (predicate != null) {
                this.emitPredicate(path, predicate);
            } else {
                this.emit("()");
            }
        }
    }

    protected void emitPredicate(LocationPath path, Expression predicate) {
        if (predicate instanceof IntegerLiteral) {
            IntegerLiteral numericPredicate = (IntegerLiteral)predicate;
            this.emit("(" + (numericPredicate.getNumericValue() - 1L) + ")");
        } else {
            this.emit("(" + path.getTrailingPredicateIdentifier() + ")");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void emitStep(LocationPathStep step) {
        if (step instanceof ElementStep) {
            Axis axis = step.getAxis();
            if (axis != null) {
                if (axis != Axis.PRECEDING_SIBLING) throw new UnsupportedOperationException("implement me for axis " + (Object)((Object)axis));
                this.emit(".precedingSibling(\"" + step.getNamespacePrefix() + "\", \"" + step.getName() + "\")");
                return;
            } else {
                this.emit(".element(\"" + step.getNamespacePrefix() + "\", \"" + step.getName() + "\")");
            }
            return;
        } else if (step instanceof TextNodeTest) {
            this.emit(".text()");
            return;
        } else if (step instanceof ParentElementStep) {
            this.emit(".parent()");
            return;
        } else if (step instanceof XSLTCurrentStep) {
            this.emit(".current()");
            return;
        } else if (step instanceof AttributeStep) {
            AttributeStep attributeStep = (AttributeStep)step;
            this.emit(".getAttributes(\"" + attributeStep.getName() + "\")");
            return;
        } else if (step instanceof ChildElementsStep) {
            this.emit(".elements()");
            return;
        } else {
            if (step instanceof SelfNodeStep) return;
            if (!(step instanceof RootStep)) throw new UnsupportedOperationException("implement me for step type " + step.getClass().getSimpleName());
            this.emit(".root()");
        }
    }

    @Override
    public void atMethodCall(MethodCall call) {
        String scope = call.getScope();
        String methodName = call.getMethodName();
        Expression object = call.getObject();
        List<Expression> parameters = call.getParameters();
        if (scope != null) {
            this.emit(scope + ".");
        }
        object.accept(this);
        this.emit("." + methodName + "(");
        boolean first = true;
        Iterator<Expression> i$ = parameters.iterator();
        while (i$.hasNext()) {
            Expression element;
            Expression param = element = i$.next();
            if (!first) {
                this.emit(", ");
            }
            first = false;
            param.accept(this);
        }
        this.emit(")");
    }

    @Override
    public void atNumberLiteral(NumberLiteral literal) {
        this.emit("ValueUtil.asNumber(\"" + literal.getValue() + "\")");
    }

    @Override
    public void atNumericCast(NumberCast cast) {
        if (cast.getExpressionToCast().type() != ExpressionType.NumberType) {
            this.emit(NumberEmitter.asNumber(cast.getExpressionToCast(), this));
        } else {
            cast.getExpressionToCast().accept(this);
        }
    }

    @Override
    public void atParenthesizedExpression(ParenthesizedExpression expression) {
        if (!(expression.getSubExpression() instanceof Atom)) {
            this.emit("(");
            expression.getSubExpression().accept(this);
            this.emit(")");
        } else {
            expression.getSubExpression().accept(this);
        }
    }

    @Override
    public void atStringCast(StringCast cast) {
        if (cast.getExpressionToCast().type() == ExpressionType.StringType) {
            cast.getExpressionToCast().accept(this);
        } else {
            this.emit("ValueUtil.asString(");
            cast.getExpressionToCast().accept(this);
            this.emit(")");
        }
    }

    @Override
    public void atStringLiteral(StringLiteral literal) {
        this.emit(literal.getValue());
    }

    @Override
    public void atUnaryExpression(UnaryExpression expression) {
        boolean atom = expression.getRhs() instanceof Atom;
        this.emit(expression.getOp());
        if (!atom) {
            this.emit("(");
        }
        BooleanCast.cast(expression.getRhs()).accept(this);
        if (!atom) {
            this.emit(")");
        }
    }

    @Override
    public void atVariable(Variable variable) {
        this.emit(variable.getName());
    }

    @Override
    public void atVariableExpression(VariableExpression expression) {
        expression.getVariable().accept(this);
    }

    @Override
    public void atBindingReference(BindingReference reference) {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    public void atBooleanBinaryExpression(BooleanBinaryExpression expression) {
        BooleanCast.cast(expression.getLhs()).accept(this);
        this.emit(" " + expression.getOperator() + " ");
        BooleanCast.cast(expression.getRhs()).accept(this);
    }

    @Override
    public void atContextElementValue(ContextNodeValue value) {
        this.emit("getContextNodeValue()");
    }

    @Override
    public void atNumberComparisonExpression(ComparisonExpression expression) {
        this.emit(expression.getOperator().toUpperCase() + ".op().compare(");
        expression.getLhs().accept(this);
        this.emit(", ");
        expression.getRhs().accept(this);
        this.emit(")");
    }

    @Override
    public void atEqualsExpression(EqualsExpression expression) {
        Expression lhs = expression.getLhs();
        Expression rhs = expression.getRhs();
        if (lhs.type() == ExpressionType.NodeSet || rhs.type() == ExpressionType.NodeSet) {
            this.emit("EQ.op().compare(");
            lhs.accept(this);
            this.emit(", ");
            rhs.accept(this);
            this.emit(")");
        } else if (lhs.type() == ExpressionType.IntegerType && rhs.type() == ExpressionType.IntegerType) {
            this.emit("(");
            lhs.accept(this);
            this.emit(" == ");
            rhs.accept(this);
            this.emit(")");
        } else if (lhs.type() == ExpressionType.NumberType || lhs.type() == ExpressionType.IntegerType || rhs.type() == ExpressionType.NumberType || rhs.type() == ExpressionType.IntegerType) {
            this.emit("EQ.op().compare(");
            lhs.accept(this);
            this.emit(", ");
            rhs.accept(this);
            this.emit(")");
        } else if (lhs.type() == ExpressionType.BooleanType || rhs.type() == ExpressionType.BooleanType) {
            this.emit("(");
            lhs.accept(this);
            this.emit(" == ");
            rhs.accept(this);
            this.emit(")");
        } else if (lhs.type() != ExpressionType.StringType || rhs.type() != ExpressionType.StringType) {
            lhs = lhs.type() == ExpressionType.StringType ? lhs : new StringCast(lhs);
            rhs = rhs.type() == ExpressionType.StringType ? rhs : new StringCast(rhs);
            lhs.accept(this);
            this.emit(".equals(");
            rhs.accept(this);
            this.emit(")");
        } else {
            lhs.accept(this);
            this.emit(".equals(");
            rhs.accept(this);
            this.emit(")");
        }
    }

    @Override
    public void atConcatExpression(ConcatExpression expression) {
        Expression lhs = expression.getLhs();
        Expression rhs = expression.getRhs();
        this.emit("(");
        if (lhs.type() != ExpressionType.StringType) {
            this.emit("(");
            lhs.accept(this);
            this.emit(")");
        } else {
            lhs.accept(this);
        }
        this.emit(" + ");
        if (rhs.type() != ExpressionType.StringType) {
            this.emit("(");
            rhs.accept(this);
            this.emit(")");
        } else {
            rhs.accept(this);
        }
        this.emit(")");
    }

    @Override
    public void atIntegerLiteral(IntegerLiteral literal) {
        this.emit("" + literal.getNumericValue());
    }

    @Override
    public void atTextExpression(TextExpression expression) {
        this.emit("getContextNodeValue()");
    }

    @Override
    public void atUnionExpression(UnionExpression unionExpression) {
        this.emit("UNION.op().eval(");
        unionExpression.getLhs().accept(this);
        this.emit(", ");
        unionExpression.getRhs().accept(this);
        this.emit(")");
    }

    @Override
    public void atNotEqualsExpression(NotEqualsExpression expression) {
        Expression lhs = expression.getLhs();
        Expression rhs = expression.getRhs();
        this.emit("NEQ.op().compare(");
        lhs.accept(this);
        this.emit(", ");
        rhs.accept(this);
        this.emit(")");
    }

    @Override
    public void atIntegerCast(IntegerCast integerCast) {
        this.emit("ValueUtil.asInteger(");
        integerCast.getExpressionToCast().accept(this);
        this.emit(")");
    }

    @Override
    public void atPosition(Position position) {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    public void atCountMatchPreceding(CountMatchPreceding countMatchPreceding) {
        this.emit("matchCount");
    }
}

