/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression.emitter;

import com.gsl.xslt2java.expression.BooleanCast;
import com.gsl.xslt2java.expression.BooleanLiteral;
import com.gsl.xslt2java.expression.ContextNodeValue;
import com.gsl.xslt2java.expression.CountExpression;
import com.gsl.xslt2java.expression.Current;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.FunctionCall;
import com.gsl.xslt2java.expression.IfExpression;
import com.gsl.xslt2java.expression.IntegerCast;
import com.gsl.xslt2java.expression.IntegerLiteral;
import com.gsl.xslt2java.expression.LocationPathExpression;
import com.gsl.xslt2java.expression.MethodCall;
import com.gsl.xslt2java.expression.NumberCast;
import com.gsl.xslt2java.expression.NumberLiteral;
import com.gsl.xslt2java.expression.ParenthesizedExpression;
import com.gsl.xslt2java.expression.Position;
import com.gsl.xslt2java.expression.StringCast;
import com.gsl.xslt2java.expression.StringLiteral;
import com.gsl.xslt2java.expression.SumExpression;
import com.gsl.xslt2java.expression.TextExpression;
import com.gsl.xslt2java.expression.UnaryExpression;
import com.gsl.xslt2java.expression.Variable;
import com.gsl.xslt2java.expression.VariableExpression;
import com.gsl.xslt2java.expression.binary.AdditiveExpression;
import com.gsl.xslt2java.expression.binary.BooleanBinaryExpression;
import com.gsl.xslt2java.expression.binary.ComparisonExpression;
import com.gsl.xslt2java.expression.binary.ConcatExpression;
import com.gsl.xslt2java.expression.binary.EqualsExpression;
import com.gsl.xslt2java.expression.binary.MultiplicativeExpression;
import com.gsl.xslt2java.expression.binary.NotEqualsExpression;
import com.gsl.xslt2java.expression.binary.UnionExpression;
import com.gsl.xslt2java.expression.emitter.AbstractStringEmitter;
import com.gsl.xslt2java.expression.emitter.JavaEmitter;
import com.gsl.xslt2java.expression.special.CountMatchPreceding;
import com.gsl.xslt2java.transformer.BindingReference;

public final class NumberEmitter
extends AbstractStringEmitter {
    private final AbstractStringEmitter javaEmitter;

    private NumberEmitter() {
        this.javaEmitter = new JavaEmitter();
    }

    private NumberEmitter(AbstractStringEmitter javaEmitter) {
        this.javaEmitter = javaEmitter;
    }

    public static String asNumber(Expression expression) {
        NumberEmitter anv = new NumberEmitter();
        expression.accept(anv);
        return anv.getString();
    }

    public static String asNumber(Expression expression, AbstractStringEmitter javaEmitter) {
        NumberEmitter anv = new NumberEmitter(javaEmitter);
        expression.accept(anv);
        return anv.getString();
    }

    private void castToNumber(Expression expression) {
        this.javaEmitter.emit("ValueUtil.asNumber(");
        expression.accept(this.javaEmitter);
        this.javaEmitter.emit(")");
    }

    @Override
    public void atBindingReference(BindingReference reference) {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    public void atBooleanBinaryExpression(BooleanBinaryExpression expression) {
        this.emit("((" + this.asJava(expression) + ") ? 1 : 0)");
    }

    @Override
    public void atBooleanCast(BooleanCast cast) {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    public void atBooleanLiteral(BooleanLiteral literal) {
        if (literal.getBooleanValue()) {
            this.emit("1");
        } else {
            this.emit("0");
        }
    }

    @Override
    public void atContextElementValue(ContextNodeValue expression) {
        this.castToNumber(expression);
    }

    @Override
    public void atCountExpression(CountExpression expression) {
        this.castToNumber(expression);
    }

    @Override
    public void atCurrent(Current current) {
        this.castToNumber(current);
    }

    @Override
    public void atFunctionCall(FunctionCall call) {
        this.castToNumber(call);
    }

    @Override
    public void atIfExpression(IfExpression expression) {
        this.castToNumber(expression);
    }

    @Override
    public void atLocationPathExpression(LocationPathExpression expression) {
        this.javaEmitter.emit("ValueUtil.asNumber(");
        expression.accept(this.javaEmitter);
        this.javaEmitter.emit(")");
    }

    @Override
    public void atMethodCall(MethodCall call) {
        this.castToNumber(call);
    }

    @Override
    public void atNumberComparisonExpression(ComparisonExpression expression) {
        this.castToNumber(expression);
    }

    @Override
    public void atNumberLiteral(NumberLiteral literal) {
        this.emit(literal.getValue());
    }

    @Override
    public void atNumericCast(NumberCast cast) {
        this.emit(this.asJava(cast));
    }

    @Override
    public void atParenthesizedExpression(ParenthesizedExpression expression) {
        expression.getSubExpression().accept(this);
    }

    @Override
    public void atStringCast(StringCast cast) {
        this.castToNumber(cast);
    }

    @Override
    public void atStringLiteral(StringLiteral literal) {
        this.castToNumber(literal);
    }

    @Override
    public void atUnaryExpression(UnaryExpression expression) {
        this.castToNumber(expression);
    }

    @Override
    public void atVariable(Variable variable) {
        this.castToNumber(variable);
    }

    @Override
    public void atVariableExpression(VariableExpression expression) {
        this.castToNumber(expression);
    }

    @Override
    public void atEqualsExpression(EqualsExpression expression) {
        this.castToNumber(expression);
    }

    @Override
    public void atConcatExpression(ConcatExpression expression) {
        this.castToNumber(expression);
    }

    @Override
    public void atSumExpression(SumExpression expression) {
        this.emit(this.asJava(expression));
    }

    @Override
    public void atIntegerLiteral(IntegerLiteral literal) {
        this.emit(literal.getValue());
    }

    @Override
    public void atAdditiveExpression(AdditiveExpression expression) {
        this.emit(this.asJava(expression));
    }

    @Override
    public void atMultiplicativeExpression(MultiplicativeExpression expression) {
        this.emit(this.asJava(expression));
    }

    @Override
    public void atTextExpression(TextExpression expression) {
    }

    @Override
    public void atUnionExpression(UnionExpression unionExpression) {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    public void atNotEqualsExpression(NotEqualsExpression notEqualsExpression) {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    public void atIntegerCast(IntegerCast integerCast) {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    public void atPosition(Position position) {
        this.emit("position");
    }

    @Override
    public void atCountMatchPreceding(CountMatchPreceding countMatchPreceding) {
        throw new UnsupportedOperationException("implement me!");
    }
}

