/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression.emitter;

import com.gsl.xslt2java.expression.BooleanCast;
import com.gsl.xslt2java.expression.ContextNodeValue;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.LocationPathCatalog;
import com.gsl.xslt2java.expression.LocationPathExpression;
import com.gsl.xslt2java.expression.Position;
import com.gsl.xslt2java.expression.binary.EqualsExpression;
import com.gsl.xslt2java.expression.emitter.JavaEmitter;
import com.gsl.xslt2java.expression.types.ExpressionType;
import com.gsl.xslt2java.xpath.LocationPath;
import com.gsl.xslt2java.xpath.LocationPathStep;
import com.gsl.xslt2java.xpath.TextNodeTest;
import com.gsl.xslt2java.xpath.XSLTCurrentStep;

public class PredicateEmitter
extends JavaEmitter {
    protected PredicateEmitter() {
    }

    public static String asPredicate(Expression e) {
        return PredicateEmitter.asPredicate(e, false);
    }

    public static String asPredicate(Expression e, boolean complex) {
        PredicateEmitter v = new PredicateEmitter();
        v.setComplex(complex);
        e.accept(v);
        return v.getString();
    }

    @Override
    public void atBooleanCast(BooleanCast cast) {
        this.emit("ValueUtil.asBoolean(");
        cast.getSubExpression().accept(this);
        this.emit(")");
    }

    @Override
    public void atPosition(Position p) {
        this.emit("position");
    }

    @Override
    public void atContextElementValue(ContextNodeValue value) {
        this.emit("ValueUtil.asString(contextNode)");
    }

    @Override
    public void atEqualsExpression(EqualsExpression expression) {
        Expression lhs = expression.getLhs();
        Expression rhs = expression.getRhs();
        if (lhs.type() == ExpressionType.NumberType || rhs.type() == ExpressionType.NumberType) {
            this.emit("NumberUtil.equals(");
            lhs.accept(this);
            this.emit(", ");
            rhs.accept(this);
            this.emit(")");
        } else if (lhs.type() == ExpressionType.BooleanType || rhs.type() == ExpressionType.BooleanType) {
            this.emit("(");
            lhs.accept(this);
            this.emit(" == ");
            rhs.accept(this);
            this.emit(")");
        } else {
            this.emit("EQ.op().compare(");
            lhs.accept(this);
            this.emit(", ");
            rhs.accept(this);
            this.emit(")");
        }
    }

    @Override
    public void atLocationPathExpression(LocationPathExpression expression) {
        LocationPath path = expression.getPath();
        LocationPathStep lastStep = path.getLastStep();
        if (lastStep instanceof TextNodeTest && path.stepCount() == 1) {
            this.emit("getContextNode().text()");
        } else if (lastStep instanceof XSLTCurrentStep) {
            this.emit("getContextNodeValue()");
        } else if (path.isRelative()) {
            if (this.isComplex()) {
                this.emitComplexRelativePath(expression);
            } else {
                this.emitSimpleRelativePath(expression);
            }
        } else {
            LocationPathCatalog lpCat = expression.getLocationPathCatalog();
            this.emit(PredicateEmitter.convertNameToGetter(lpCat.mapPathToPropertyName(expression.getPath())));
            this.emit("(contextNode)");
        }
    }

    private void emitComplexRelativePath(LocationPathExpression expression) {
        boolean skipFirst;
        LocationPath path = expression.getPath();
        LocationPathStep firstStep = path.getFirstStep();
        if (firstStep instanceof XSLTCurrentStep) {
            this.emit("currentNode");
            skipFirst = true;
        } else {
            this.emit("contextNode");
            skipFirst = false;
        }
        for (LocationPathStep step : path.getSteps()) {
            LocationPathStep lastStep;
            Expression predicate;
            if (skipFirst) {
                skipFirst = false;
            } else {
                this.emitStep(step);
            }
            if ((predicate = (lastStep = path.getLastStep()).getPredicate()) == null) continue;
            this.emit(".applyPredicate");
            this.emitPredicate(path, predicate);
        }
    }

    private void emitSimpleRelativePath(LocationPathExpression expression) {
        LocationPath path = expression.getPath();
        LocationPathStep firstStep = path.getFirstStep();
        if (firstStep instanceof XSLTCurrentStep) {
            if (path.stepCount() == 1) {
                this.emit("getContextElement()");
            } else {
                LocationPathCatalog lpCat = expression.getLocationPathCatalog();
                this.emit(PredicateEmitter.convertNameToGetter(lpCat.mapPathToPropertyName(path)));
                this.emit("()");
            }
        } else {
            this.emit("contextNode");
            for (LocationPathStep step : path.getSteps()) {
                this.emitStep(step);
            }
        }
    }

    private void emitAxis(String axis) {
        if (axis != null) {
            if (axis.equals("preceding-sibling")) {
                this.emit(".precedingSibling()");
            } else {
                throw new UnsupportedOperationException("implement me!");
            }
        }
    }
}

