/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.expression.special;

import com.gsl.xslt2java.LocationPathDescriptor;
import com.gsl.xslt2java.LocationPathUseType;
import com.gsl.xslt2java.SimpleLocationPathCatalog;
import com.gsl.xslt2java.expression.AbstractExpression;
import com.gsl.xslt2java.expression.ExpressionModifier;
import com.gsl.xslt2java.expression.ExpressionVisitor;
import com.gsl.xslt2java.expression.LocationPathCatalog;
import com.gsl.xslt2java.expression.LocationPathExpression;
import com.gsl.xslt2java.expression.emitter.PredicateEmitter;
import com.gsl.xslt2java.statement.Statement;
import com.gsl.xslt2java.statement.StringStatement;
import com.gsl.xslt2java.xpath.LocationPath;
import com.gsl.xslt2java.xpath.XSLTCurrentStep;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CountMatchPreceding
extends AbstractExpression {
    private final LocationPath mainPath;
    private final LocationPath subPath;
    String[] statements = new String[]{"final NodeList<ElementNode> elements = %subPath%;", "Set<String> precedingValuesSet = (Set<String>) getMemberVars().get(\"precedingValuesSet\");", "if (precedingValuesSet == null) {", "    precedingValuesSet = new HashSet<String>();", "    getMemberVars().put(\"precedingValuesSet\", precedingValuesSet);", "}", "final List<String> stringValues = new ArrayList<String>();", "for (int i = 0; i < elements.size(); i++) {", "    final String stringValue = elements.get(i).stringValue();", "    stringValues.add(stringValue);", "}", "int matchCount = 0;", "for (int i = 0; i < stringValues.size(); i++) {", "    if (precedingValuesSet.contains(stringValues.get(i))) {", "        matchCount++;", "    }", "}", "precedingValuesSet.addAll(stringValues);"};

    public CountMatchPreceding(LocationPath mainPath, LocationPath subPath) {
        this.mainPath = mainPath;
        this.subPath = subPath;
    }

    public LocationPath getMainPath() {
        return this.mainPath;
    }

    public LocationPath getSubPath() {
        return this.subPath;
    }

    @Override
    public boolean hasComplexPaths() {
        return true;
    }

    @Override
    public CountMatchPreceding clone() {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    protected void modifyChildren(ExpressionModifier modifier) {
    }

    @Override
    public List<Statement> getSupportingStatements() {
        ArrayList<Statement> result = new ArrayList<Statement>();
        LocationPath currentSubPath = new LocationPath(new XSLTCurrentStep());
        currentSubPath.appendPath(this.getSubPath());
        LocationPathExpression lpe = new LocationPathExpression(currentSubPath, (LocationPathCatalog)new SimpleLocationPathCatalog());
        String subPathLookup = PredicateEmitter.asPredicate(lpe, true);
        for (String statementString : this.statements) {
            result.add(new StringStatement(statementString.replaceAll("%subPath%", subPathLookup)));
        }
        return result;
    }

    @Override
    public void accept(ExpressionVisitor v) {
        v.atCountMatchPreceding(this);
    }

    @Override
    public Set<LocationPathDescriptor> requiredLocationPathDescriptors() {
        HashSet<LocationPathDescriptor> descriptors = new HashSet<LocationPathDescriptor>();
        descriptors.add(new LocationPathDescriptor(this.getSubPath(), "subPath", LocationPathUseType.Branch));
        return descriptors;
    }

    @Override
    public Set<LocationPath> requiredLocationPaths() {
        HashSet<LocationPath> requiredPaths = new HashSet<LocationPath>();
        requiredPaths.add(this.getSubPath());
        return requiredPaths;
    }
}

