/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.statement;

import com.gsl.xslt2java.LocationPathDescriptor;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionModifier;
import com.gsl.xslt2java.expression.Iteration;
import com.gsl.xslt2java.expression.emitter.JavaEmitter;
import com.gsl.xslt2java.statement.Statement;
import java.util.HashSet;
import java.util.Set;

public class ForStatement
implements Statement {
    private final Iteration iteration;
    private Expression subExpression;

    public ForStatement(Iteration iteration, Expression subExpression) {
        this.iteration = iteration;
        this.subExpression = subExpression;
    }

    public String toString() {
        String subExpressionJava = JavaEmitter.asSimpleJava(this.subExpression);
        String result = "boolean result = false;\nfor (Iterator iter = " + this.iteration.getPath().asList(false) + ".iterator(); iter.hasNext();) {\n";
        result = result + "  Node " + this.iteration.getLoopVariable().getName() + " = (Node)iter.next();\n";
        result = result + "  result |= " + subExpressionJava + ";\n";
        result = result + "}";
        return result;
    }

    @Override
    public Set<LocationPathDescriptor> requiredLocationPathDescriptors() {
        HashSet<LocationPathDescriptor> descriptors = new HashSet<LocationPathDescriptor>();
        descriptors.addAll(this.subExpression.requiredLocationPathDescriptors());
        descriptors.addAll(this.iteration.requiredLocationPathDescriptors());
        return descriptors;
    }

    @Override
    public void modifyExpressions(ExpressionModifier modifier) {
        this.subExpression = this.subExpression.modify(modifier);
    }
}

