/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.statement;

import com.gsl.xslt2java.LocationPathDescriptor;
import com.gsl.xslt2java.LocationPathUseType;
import com.gsl.xslt2java.expression.BooleanCast;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionModifier;
import com.gsl.xslt2java.expression.LocationPathCatalog;
import com.gsl.xslt2java.expression.emitter.PredicateEmitter;
import com.gsl.xslt2java.statement.Statement;
import com.gsl.xslt2java.xpath.LocationPath;
import java.util.Set;

public class PredicateClassDefinition
implements Statement {
    public static long instanceCount = 0L;
    private Expression predicate;
    private final LocationPath predicationPath;
    private final String instanceName;

    public PredicateClassDefinition(Expression predicate, LocationPath predicationPath) {
        this.predicate = predicate;
        assert (predicationPath != null);
        this.predicationPath = predicationPath;
        this.instanceName = "predicate" + instanceCount++;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String toString() {
        String predicateCheck = PredicateEmitter.asPredicate(BooleanCast.cast(this.predicate), false);
        return "final Predicate<Node> " + this.instanceName + " = new Predicate<Node>() { public boolean checkPredicate(Node contextNode, long position) { return " + predicateCheck + "; } };";
    }

    public String toComplexString() {
        String predicateCheck = PredicateEmitter.asPredicate(BooleanCast.cast(this.predicate), true);
        return "final Predicate<Node> " + this.instanceName + " = new Predicate<Node>() { public boolean checkPredicate(Node contextNode, long position) { return " + predicateCheck + "; } };";
    }

    @Override
    public Set<LocationPathDescriptor> requiredLocationPathDescriptors() {
        assert (this.predicate != null);
        LocationPathCatalog catalog = this.predicate.getLocationPathCatalog();
        String propertyName = catalog.mapPathToPropertyName(this.predicationPath);
        LocationPathDescriptor predicatedPath = new LocationPathDescriptor(this.predicationPath, propertyName, LocationPathUseType.Value);
        Set<LocationPathDescriptor> requiredPaths = this.predicate.requiredLocationPathDescriptors();
        for (LocationPathDescriptor descriptor : requiredPaths) {
            if (descriptor.promotesWithCurrent()) continue;
            descriptor.setPredicationPath(predicatedPath);
        }
        return requiredPaths;
    }

    public LocationPath getPredicationPath() {
        return this.predicationPath;
    }

    @Override
    public void modifyExpressions(ExpressionModifier modifier) {
        this.predicate = this.predicate.modify(modifier);
    }

    public Expression getExpression() {
        return this.predicate;
    }
}

