/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.transformer;

import com.gsl.xslt2java.LocationPathDescriptor;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.ExpressionModifier;
import com.gsl.xslt2java.expression.ExpressionReference;
import com.gsl.xslt2java.expression.ExpressionVisitor;
import com.gsl.xslt2java.expression.LocationPathCatalog;
import com.gsl.xslt2java.xpath.LocationPath;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BindingReference
extends ExpressionReference {
    private final Map<String, Expression> bindingTable;

    public BindingReference(String name, Map<String, Expression> bindingTable) {
        super(name);
        this.bindingTable = bindingTable;
    }

    @Override
    public LocationPathCatalog getLocationPathCatalog() {
        return this.getReferencedExpression().getLocationPathCatalog();
    }

    @Override
    public Set<LocationPathDescriptor> requiredLocationPathDescriptors() {
        return new HashSet<LocationPathDescriptor>();
    }

    @Override
    public Set<LocationPath> requiredLocationPaths() {
        return new HashSet<LocationPath>();
    }

    @Override
    public void setLocationPathCatalog(LocationPathCatalog lpc) {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    protected Expression getReferencedExpression() {
        Expression result = null;
        if (this.bindingTable != null) {
            result = this.bindingTable.get(this.getReferenceName());
        }
        return result;
    }

    @Override
    public Expression modify(ExpressionModifier modifier) {
        throw new UnsupportedOperationException("Modification not supported by BindingReference");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.atBindingReference(this);
    }

    public String toString() {
        return "BindingReference(" + this.getReferenceName() + ", " + this.getReferencedExpression() + ")";
    }

    @Override
    public void setPredicate(Expression predicateExpression) {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    public String asJavaExpression() {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    public boolean hasComplexPaths() {
        boolean result = false;
        for (LocationPathDescriptor descriptor : this.requiredLocationPathDescriptors()) {
            if (!descriptor.isComplex()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean hasPredicates() {
        boolean result = false;
        for (LocationPathDescriptor descriptor : this.requiredLocationPathDescriptors()) {
            if (!descriptor.hasPredicates()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public Expression getMainExpresssion() {
        return this.getReferencedExpression().getMainExpresssion();
    }
}

